/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.config;

import com.hedera.node.config.data.AccountsConfig;
import com.hedera.node.config.data.ContractsConfig;
import com.hedera.node.config.data.FilesConfig;
import com.hedera.node.config.data.SchedulingConfig;
import com.hedera.node.config.data.TokensConfig;
import com.hedera.node.config.data.TopicsConfig;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.LongGauge;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;

public class ConfigMetrics {
    private static final LongGauge.Config ACCOUNTS_MAX_NUMBER_CONFIG = new LongGauge.Config("app", "accountsMaxNumber").withDescription("The maximum number of accounts that can be created");
    private static final LongGauge.Config CONTRACTS_MAX_NUMBER_CONFIG = new LongGauge.Config("app", "contractsMaxNumber").withDescription("The maximum number of smart contracts that can be created");
    private static final LongGauge.Config STORAGE_SLOTS_MAX_NUMBER_CONFIG = new LongGauge.Config("app", "storageSlotsMaxNumber").withDescription("The maximum number of storage slots that can be created");
    private static final LongGauge.Config FILES_MAX_NUMBER_CONFIG = new LongGauge.Config("app", "filesMaxNumber").withDescription("The maximum number of files that can be created");
    private static final LongGauge.Config SCHEDULES_MAX_NUMBER_CONFIG = new LongGauge.Config("app", "schedulesMaxNumber").withDescription("The maximum number of schedules that can be created");
    private static final LongGauge.Config TOKENS_MAX_NUMBER_CONFIG = new LongGauge.Config("app", "tokensMaxNumber").withDescription("The maximum number of tokens that can be created");
    private static final LongGauge.Config NFTS_MAX_NUMBER_CONFIG = new LongGauge.Config("app", "nftsMaxNumber").withDescription("The maximum number of NFTs that can be created");
    private static final LongGauge.Config TOKEN_ASSOCIATIONS_MAX_NUMBER_CONFIG = new LongGauge.Config("app", "tokenAssociationsMaxNumber").withDescription("The maximum number of token associations that can be created");
    private static final LongGauge.Config TOPICS_MAX_NUMBER_CONFIG = new LongGauge.Config("app", "topicsMaxNumber").withDescription("The maximum number of topics that can be created");
    private final LongGauge accountMaxNumber;
    private final LongGauge contractsMaxNumber;
    private final LongGauge storageSlotsMaxNumber;
    private final LongGauge filesMaxNumber;
    private final LongGauge schedulesMaxNumber;
    private final LongGauge tokensMaxNumber;
    private final LongGauge nftsMaxNumber;
    private final LongGauge tokenAssocitationsMaxNumber;
    private final LongGauge topicsMaxNumber;

    public ConfigMetrics(@NonNull Metrics metrics) {
        this.accountMaxNumber = (LongGauge)metrics.getOrCreate((MetricConfig)ACCOUNTS_MAX_NUMBER_CONFIG);
        this.contractsMaxNumber = (LongGauge)metrics.getOrCreate((MetricConfig)CONTRACTS_MAX_NUMBER_CONFIG);
        this.storageSlotsMaxNumber = (LongGauge)metrics.getOrCreate((MetricConfig)STORAGE_SLOTS_MAX_NUMBER_CONFIG);
        this.filesMaxNumber = (LongGauge)metrics.getOrCreate((MetricConfig)FILES_MAX_NUMBER_CONFIG);
        this.schedulesMaxNumber = (LongGauge)metrics.getOrCreate((MetricConfig)SCHEDULES_MAX_NUMBER_CONFIG);
        this.tokensMaxNumber = (LongGauge)metrics.getOrCreate((MetricConfig)TOKENS_MAX_NUMBER_CONFIG);
        this.nftsMaxNumber = (LongGauge)metrics.getOrCreate((MetricConfig)NFTS_MAX_NUMBER_CONFIG);
        this.tokenAssocitationsMaxNumber = (LongGauge)metrics.getOrCreate((MetricConfig)TOKEN_ASSOCIATIONS_MAX_NUMBER_CONFIG);
        this.topicsMaxNumber = (LongGauge)metrics.getOrCreate((MetricConfig)TOPICS_MAX_NUMBER_CONFIG);
    }

    public void reportMetrics(@NonNull Configuration configuration) {
        AccountsConfig accountsConfig = (AccountsConfig)configuration.getConfigData(AccountsConfig.class);
        this.accountMaxNumber.set(accountsConfig.maxNumber());
        ContractsConfig contractsConfig = (ContractsConfig)configuration.getConfigData(ContractsConfig.class);
        this.contractsMaxNumber.set(contractsConfig.maxNumber());
        this.storageSlotsMaxNumber.set(contractsConfig.maxKvPairsAggregate());
        FilesConfig filesConfig = (FilesConfig)configuration.getConfigData(FilesConfig.class);
        this.filesMaxNumber.set(filesConfig.maxNumber());
        SchedulingConfig schedulingConfig = (SchedulingConfig)configuration.getConfigData(SchedulingConfig.class);
        this.schedulesMaxNumber.set(schedulingConfig.maxNumber());
        TokensConfig tokensConfig = (TokensConfig)configuration.getConfigData(TokensConfig.class);
        this.tokensMaxNumber.set(tokensConfig.maxNumber());
        this.nftsMaxNumber.set(tokensConfig.nftsMaxAllowedMints());
        this.tokenAssocitationsMaxNumber.set(tokensConfig.maxAggregateRels());
        TopicsConfig topicsConfig = (TopicsConfig)configuration.getConfigData(TopicsConfig.class);
        this.topicsMaxNumber.set(topicsConfig.maxNumber());
    }
}

