/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.records.impl;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.blockrecords.BlockInfo;
import com.hedera.hapi.node.state.blockrecords.RunningHashes;
import com.hedera.hapi.platform.state.PlatformState;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.records.BlockRecordManager;
import com.hedera.node.app.records.BlockRecordService;
import com.hedera.node.app.records.impl.BlockRecordInfoUtils;
import com.hedera.node.app.records.impl.BlockRecordStreamProducer;
import com.hedera.node.app.records.schemas.V0490BlockRecordSchema;
import com.hedera.node.app.state.SingleTransactionRecord;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.BlockRecordStreamConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.platform.state.service.WritablePlatformStateStore;
import com.swirlds.platform.state.service.schemas.V0540PlatformStateSchema;
import com.swirlds.state.State;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableSingletonStateBase;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Objects;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.Hash;

@Singleton
public final class BlockRecordManagerImpl
implements BlockRecordManager {
    private static final Logger logger = LogManager.getLogger(BlockRecordManagerImpl.class);
    private final int numBlockHashesToKeepBytes;
    private final long blockPeriodInSeconds;
    private final BlockRecordStreamProducer streamFileProducer;
    private BlockInfo lastBlockInfo;
    private boolean eventRecoveryCompleted;

    @Inject
    public BlockRecordManagerImpl(@NonNull ConfigProvider configProvider, @NonNull State state, @NonNull BlockRecordStreamProducer streamFileProducer) {
        Objects.requireNonNull(state);
        this.streamFileProducer = Objects.requireNonNull(streamFileProducer);
        this.eventRecoveryCompleted = false;
        BlockRecordStreamConfig recordStreamConfig = (BlockRecordStreamConfig)configProvider.getConfiguration().getConfigData(BlockRecordStreamConfig.class);
        this.blockPeriodInSeconds = recordStreamConfig.logPeriod();
        this.numBlockHashesToKeepBytes = recordStreamConfig.numOfBlockHashesInState() * BlockRecordInfoUtils.HASH_SIZE;
        ReadableStates states = state.getReadableStates("BlockRecordService");
        ReadableSingletonState blockInfoState = states.getSingleton(V0490BlockRecordSchema.BLOCKS_STATE_ID);
        this.lastBlockInfo = (BlockInfo)blockInfoState.get();
        assert (this.lastBlockInfo != null) : "Cannot be null, because this state is created at genesis";
        ReadableSingletonState runningHashState = states.getSingleton(V0490BlockRecordSchema.RUNNING_HASHES_STATE_ID);
        RunningHashes lastRunningHashes = (RunningHashes)runningHashState.get();
        assert (lastRunningHashes != null) : "Cannot be null, because this state is created at genesis";
        this.streamFileProducer.initRunningHash(lastRunningHashes);
    }

    @Override
    public void close() {
        try {
            this.streamFileProducer.close();
        }
        catch (Exception e) {
            logger.warn("Failed to close streamFileProducer properly", (Throwable)e);
        }
    }

    @Override
    public boolean willOpenNewBlock(@NonNull Instant consensusTime, @NonNull State state) {
        if (BlockRecordService.EPOCH.equals((Object)this.lastBlockInfo.firstConsTimeOfCurrentBlock())) {
            return true;
        }
        long currentBlockPeriod = this.getBlockPeriod(this.lastBlockInfo.firstConsTimeOfCurrentBlock());
        long newBlockPeriod = this.getBlockPeriod(consensusTime);
        if (newBlockPeriod > currentBlockPeriod) {
            return true;
        }
        PlatformState platformState = (PlatformState)state.getReadableStates("PlatformStateService").getSingleton(V0540PlatformStateSchema.PLATFORM_STATE_STATE_ID).get();
        Objects.requireNonNull(platformState);
        return platformState.freezeTime() != null && platformState.freezeTimeOrThrow().equals((Object)platformState.lastFrozenTime());
    }

    @Override
    public boolean startUserTransaction(@NonNull Instant consensusTime, @NonNull State state) {
        boolean isFirstTransactionAfterFreezeRestart;
        if (BlockRecordService.EPOCH.equals((Object)this.lastBlockInfo.firstConsTimeOfCurrentBlock())) {
            Timestamp now = new Timestamp(consensusTime.getEpochSecond(), consensusTime.getNano());
            this.lastBlockInfo = this.lastBlockInfo.copyBuilder().consTimeOfLastHandledTxn(now).firstConsTimeOfCurrentBlock(now).build();
            this.putLastBlockInfo(state);
            this.streamFileProducer.switchBlocks(-1L, 0L, consensusTime);
            return true;
        }
        long currentBlockPeriod = this.getBlockPeriod(this.lastBlockInfo.firstConsTimeOfCurrentBlock());
        long newBlockPeriod = this.getBlockPeriod(consensusTime);
        PlatformState platformState = (PlatformState)state.getReadableStates("PlatformStateService").getSingleton(V0540PlatformStateSchema.PLATFORM_STATE_STATE_ID).get();
        Objects.requireNonNull(platformState);
        boolean bl = isFirstTransactionAfterFreezeRestart = platformState.freezeTime() != null && platformState.freezeTimeOrThrow().equals((Object)platformState.lastFrozenTime());
        if (isFirstTransactionAfterFreezeRestart) {
            new WritablePlatformStateStore(state.getWritableStates("PlatformStateService")).setFreezeTime(null);
        }
        if (newBlockPeriod > currentBlockPeriod || isFirstTransactionAfterFreezeRestart) {
            Bytes lastBlockHashBytes = this.streamFileProducer.getRunningHash();
            long justFinishedBlockNumber = this.lastBlockInfo.lastBlockNumber() + 1L;
            this.lastBlockInfo = this.infoOfJustFinished(this.lastBlockInfo, justFinishedBlockNumber, lastBlockHashBytes, consensusTime);
            this.putLastBlockInfo(state);
            if (logger.isDebugEnabled()) {
                logger.debug("--- BLOCK UPDATE ---\n  Finished: #{} (started @ {}) with hash {}\n  Starting: #{} @ {}", (Object)justFinishedBlockNumber, (Object)this.lastBlockInfo.firstConsTimeOfCurrentBlock(), (Object)new Hash(lastBlockHashBytes, DigestType.SHA_384), (Object)(justFinishedBlockNumber + 1L), (Object)consensusTime);
            }
            this.switchBlocksAt(consensusTime);
            return true;
        }
        return false;
    }

    @Override
    public void markMigrationRecordsStreamed() {
        this.lastBlockInfo = this.lastBlockInfo.copyBuilder().migrationRecordsStreamed(true).build();
    }

    @VisibleForTesting
    public void switchBlocksAt(@NonNull Instant consensusTime) {
        this.streamFileProducer.switchBlocks(this.lastBlockInfo.lastBlockNumber(), this.lastBlockInfo.lastBlockNumber() + 1L, consensusTime);
    }

    private void putLastBlockInfo(@NonNull State state) {
        WritableStates states = state.getWritableStates("BlockRecordService");
        WritableSingletonState blockInfoState = states.getSingleton(V0490BlockRecordSchema.BLOCKS_STATE_ID);
        blockInfoState.put((Object)this.lastBlockInfo);
    }

    @Override
    public void endUserTransaction(@NonNull Stream<SingleTransactionRecord> recordStreamItems, @NonNull State state) {
        if (!this.eventRecoveryCompleted) {
            this.eventRecoveryCompleted = true;
        }
        this.streamFileProducer.writeRecordStreamItems(recordStreamItems);
    }

    @Override
    public void endRound(@NonNull State state) {
        Bytes currentRunningHash = this.streamFileProducer.getRunningHash();
        WritableStates states = state.getWritableStates("BlockRecordService");
        WritableSingletonState runningHashesState = states.getSingleton(V0490BlockRecordSchema.RUNNING_HASHES_STATE_ID);
        RunningHashes existingRunningHashes = (RunningHashes)runningHashesState.get();
        assert (existingRunningHashes != null) : "This cannot be null because genesis migration sets it";
        RunningHashes runningHashes = new RunningHashes(currentRunningHash, existingRunningHashes.nMinus1RunningHash(), existingRunningHashes.nMinus2RunningHash(), existingRunningHashes.nMinus3RunningHash());
        runningHashesState.put((Object)runningHashes);
        ((WritableSingletonStateBase)runningHashesState).commit();
    }

    public long lastBlockNo() {
        return this.lastBlockInfo.lastBlockNumber();
    }

    public Instant firstConsTimeOfLastBlock() {
        return BlockRecordInfoUtils.firstConsTimeOfLastBlock(this.lastBlockInfo);
    }

    public Bytes getRunningHash() {
        return this.streamFileProducer.getRunningHash();
    }

    @Nullable
    public Bytes lastBlockHash() {
        return BlockRecordInfoUtils.lastBlockHash(this.lastBlockInfo);
    }

    @Nullable
    public Bytes prngSeed() {
        return this.streamFileProducer.getNMinus3RunningHash();
    }

    public long blockNo() {
        return this.lastBlockInfo.lastBlockNumber() + 1L;
    }

    @Override
    @NonNull
    public Instant consTimeOfLastHandledTxn() {
        Timestamp lastHandledTxn = this.lastBlockInfo.consTimeOfLastHandledTxn();
        return lastHandledTxn != null ? Instant.ofEpochSecond(lastHandledTxn.seconds(), lastHandledTxn.nanos()) : Instant.EPOCH;
    }

    @NonNull
    public Timestamp blockTimestamp() {
        return this.lastBlockInfo.firstConsTimeOfCurrentBlockOrThrow();
    }

    @Nullable
    public Bytes blockHashByBlockNumber(long blockNo) {
        return BlockRecordInfoUtils.blockHashByBlockNumber(this.lastBlockInfo, blockNo);
    }

    @Override
    public void setLastTopLevelTime(@NonNull Instant consensusTime, @NonNull State state) {
        Timestamp now = HapiUtils.asTimestamp((Instant)consensusTime);
        BlockInfo.Builder builder = this.lastBlockInfo.copyBuilder().consTimeOfLastHandledTxn(now).lastUsedConsTime(now);
        this.updateBlockInfo(builder.build(), state);
    }

    @Override
    public void setLastUsedConsensusTime(@NonNull Instant consensusTime, @NonNull State state) {
        Objects.requireNonNull(consensusTime);
        Objects.requireNonNull(state);
        BlockInfo newBlockInfo = new BlockInfo(this.lastBlockInfo.lastBlockNumber(), this.lastBlockInfo.firstConsTimeOfLastBlock(), this.lastBlockInfo.blockHashes(), this.lastBlockInfo.consTimeOfLastHandledTxn(), this.lastBlockInfo.migrationRecordsStreamed(), this.lastBlockInfo.firstConsTimeOfCurrentBlock(), HapiUtils.asTimestamp((Instant)consensusTime), this.lastBlockInfo.lastIntervalProcessTime());
        this.updateBlockInfo(newBlockInfo, state);
    }

    @Override
    @NonNull
    public Instant lastUsedConsensusTime() {
        return this.lastBlockInfo.hasLastUsedConsTime() ? HapiUtils.asInstant((Timestamp)this.lastBlockInfo.lastUsedConsTimeOrThrow()) : Instant.EPOCH;
    }

    @Override
    public void setLastIntervalProcessTime(@NonNull Instant lastIntervalProcessTime, @NonNull State state) {
        Objects.requireNonNull(lastIntervalProcessTime);
        Objects.requireNonNull(state);
        BlockInfo newBlockInfo = this.lastBlockInfo.copyBuilder().lastIntervalProcessTime(HapiUtils.asTimestamp((Instant)lastIntervalProcessTime)).build();
        this.updateBlockInfo(newBlockInfo, state);
    }

    @Override
    @NonNull
    public Instant lastIntervalProcessTime() {
        return this.lastBlockInfo.hasLastIntervalProcessTime() ? HapiUtils.asInstant((Timestamp)this.lastBlockInfo.lastIntervalProcessTimeOrThrow()) : Instant.EPOCH;
    }

    public static boolean isDefaultConsTimeOfLastHandledTxn(@Nullable BlockInfo blockInfo) {
        if (blockInfo == null || blockInfo.consTimeOfLastHandledTxn() == null) {
            return true;
        }
        Instant inst = Instant.ofEpochSecond(blockInfo.consTimeOfLastHandledTxn().seconds(), blockInfo.consTimeOfLastHandledTxn().nanos());
        return !inst.isAfter(Instant.EPOCH);
    }

    private long getBlockPeriod(@Nullable Instant consensusTimestamp) {
        if (consensusTimestamp == null) {
            return 0L;
        }
        return consensusTimestamp.getEpochSecond() / this.blockPeriodInSeconds;
    }

    private long getBlockPeriod(@Nullable Timestamp consensusTimestamp) {
        if (consensusTimestamp == null) {
            return 0L;
        }
        return consensusTimestamp.seconds() / this.blockPeriodInSeconds;
    }

    private BlockInfo infoOfJustFinished(@NonNull BlockInfo lastBlockInfo, long justFinishedBlockNumber, @NonNull Bytes hashOfJustFinishedBlock, @NonNull Instant currentBlockFirstTransactionTime) {
        byte[] newBlockHashesBytes;
        byte[] blockHashesBytes = lastBlockInfo.blockHashes().toByteArray();
        if (blockHashesBytes.length < this.numBlockHashesToKeepBytes) {
            newBlockHashesBytes = new byte[blockHashesBytes.length + BlockRecordInfoUtils.HASH_SIZE];
            System.arraycopy(blockHashesBytes, 0, newBlockHashesBytes, 0, blockHashesBytes.length);
            hashOfJustFinishedBlock.getBytes(0L, newBlockHashesBytes, newBlockHashesBytes.length - BlockRecordInfoUtils.HASH_SIZE, BlockRecordInfoUtils.HASH_SIZE);
        } else {
            newBlockHashesBytes = blockHashesBytes;
            System.arraycopy(newBlockHashesBytes, BlockRecordInfoUtils.HASH_SIZE, newBlockHashesBytes, 0, newBlockHashesBytes.length - BlockRecordInfoUtils.HASH_SIZE);
            hashOfJustFinishedBlock.getBytes(0L, newBlockHashesBytes, newBlockHashesBytes.length - BlockRecordInfoUtils.HASH_SIZE, BlockRecordInfoUtils.HASH_SIZE);
        }
        return new BlockInfo(justFinishedBlockNumber, lastBlockInfo.firstConsTimeOfCurrentBlock(), Bytes.wrap((byte[])newBlockHashesBytes), lastBlockInfo.consTimeOfLastHandledTxn(), lastBlockInfo.migrationRecordsStreamed(), new Timestamp(currentBlockFirstTransactionTime.getEpochSecond(), currentBlockFirstTransactionTime.getNano()), lastBlockInfo.lastUsedConsTime(), lastBlockInfo.lastIntervalProcessTime());
    }

    private void updateBlockInfo(@NonNull BlockInfo newBlockInfo, @NonNull State state) {
        WritableStates states = state.getWritableStates("BlockRecordService");
        WritableSingletonState blockInfoState = states.getSingleton(V0490BlockRecordSchema.BLOCKS_STATE_ID);
        blockInfoState.put((Object)newBlockInfo);
        ((WritableSingletonStateBase)blockInfoState).commit();
        this.lastBlockInfo = newBlockInfo;
    }
}

