/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.sysfiles.domain;

import com.google.common.primitives.Longs;
import com.hedera.node.app.hapi.utils.sysfiles.ParsingUtils;
import java.util.Arrays;
import org.hiero.base.utility.CommonUtils;

public record KnownBlockValues(byte[] hash, long number) {
    private static final int KECCAK256_HASH_LENGTH = 32;
    public static final KnownBlockValues MISSING_BLOCK_VALUES = new KnownBlockValues(new byte[0], 0L);

    public static KnownBlockValues from(String literal) {
        if (literal.isBlank()) {
            return MISSING_BLOCK_VALUES;
        }
        return ParsingUtils.fromTwoPartDelimited(literal, "@", (hash, number) -> {
            if (((byte[])hash).length != 32) {
                throw new IllegalArgumentException("Wrong hash length in '" + literal + "'");
            }
            if (number <= 0L) {
                throw new IllegalArgumentException("Non-positive block number in '" + literal + "'");
            }
        }, CommonUtils::unhex, Long::parseLong, KnownBlockValues::new);
    }

    public boolean isMissing() {
        return this.hash.length == 0;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || KnownBlockValues.class != other.getClass()) {
            return false;
        }
        KnownBlockValues that = (KnownBlockValues)other;
        return this.number == that.number && Arrays.equals(this.hash, that.hash);
    }

    @Override
    public int hashCode() {
        return 31 * Longs.hashCode((long)this.number) + Arrays.hashCode(this.hash);
    }

    @Override
    public String toString() {
        return "KnownBlockValues{hash=" + CommonUtils.hex((byte[])this.hash) + ", number=" + this.number + "}";
    }
}

