/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.crypto;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.bouncycastle.jcajce.provider.digest.RIPEMD160;
import org.bouncycastle.jcajce.provider.digest.SHA256;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.hyperledger.besu.crypto.BesuProvider;
import org.hyperledger.besu.crypto.Blake2bfMessageDigest;

public class MessageDigestFactory {
    public static final String KECCAK256_ALG = "KECCAK-256";
    public static final String SHA256_ALG = "SHA-256";
    public static final String RIPEMD160_ALG = "RIPEMD160";
    public static final String BLAKE2BF_ALG = "BLAKE2BF";

    private MessageDigestFactory() {
    }

    public static MessageDigest create(String algorithm) throws NoSuchAlgorithmException {
        return switch (algorithm) {
            case KECCAK256_ALG -> new Keccak.Digest256();
            case SHA256_ALG -> new SHA256.Digest();
            case RIPEMD160_ALG -> new RIPEMD160.Digest();
            case BLAKE2BF_ALG -> new Blake2bfMessageDigest();
            default -> MessageDigest.getInstance(algorithm);
        };
    }

    static {
        Security.addProvider(new BesuProvider());
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

