/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.code.CodeSection;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.ReturnStack;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.InvalidOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class CallFOperation
extends AbstractOperation {
    public static final int OPCODE = 227;
    static final Operation.OperationResult callfSuccess = new Operation.OperationResult(5L, null);
    static final Operation.OperationResult callfStackOverflow = new Operation.OperationResult(5L, ExceptionalHaltReason.TOO_MANY_STACK_ITEMS);

    public CallFOperation(GasCalculator gasCalculator) {
        super(227, "CALLF", 0, 0, gasCalculator);
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        Code code = frame.getCode();
        if (code.getEofVersion() == 0) {
            return InvalidOperation.INVALID_RESULT;
        }
        int pc = frame.getPC();
        int section = code.readBigEndianU16(pc + 1);
        CodeSection info = code.getCodeSection(section);
        int operandStackSize = frame.stackSize();
        if (operandStackSize > 1024 - info.getMaxStackHeight() + info.getInputs()) {
            return callfStackOverflow;
        }
        frame.getReturnStack().push(new ReturnStack.ReturnStackItem(frame.getSection(), pc + 2));
        frame.setPC(info.getEntryPoint() - 1);
        frame.setSection(section);
        return callfSuccess;
    }
}

