/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.update.address_0x16c;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.google.common.primitives.Longs;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.token.TokenUpdateNftsTransactionBody;
import com.hedera.hapi.node.token.TokenUpdateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaNativeOperations;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.AddressIdConverter;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.update.UpdateCommonDecoder;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.update.address_0x16c.UpdateKeysTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.update.address_0x16c.UpdateNFTsMetadataTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.update.address_0x16c.UpdateTranslator;
import com.hedera.node.app.service.contract.impl.exec.utils.TokenKeyWrapper;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class UpdateDecoder
extends UpdateCommonDecoder {
    @Inject
    public UpdateDecoder() {
    }

    public TransactionBody decodeTokenUpdateWithMetadata(@NonNull HtsCallAttempt attempt) {
        Tuple call = UpdateTranslator.TOKEN_UPDATE_INFO_FUNCTION_WITH_METADATA.decodeCall(attempt.input().toArrayUnsafe());
        TokenUpdateTransactionBody.Builder decoded = this.decodeUpdateWithMeta(call, attempt.addressIdConverter(), attempt.nativeOperations());
        return TransactionBody.newBuilder().tokenUpdate(decoded).build();
    }

    @Override
    protected Tuple decodeCall(@NonNull HtsCallAttempt attempt) {
        return UpdateKeysTranslator.TOKEN_UPDATE_KEYS_16C.decodeCall(attempt.input().toArrayUnsafe());
    }

    public TokenUpdateTransactionBody.Builder decodeUpdateWithMeta(@NonNull Tuple call, @NonNull AddressIdConverter addressIdConverter, @NonNull HederaNativeOperations nativeOperation) {
        Bytes tokenMetadata;
        TokenUpdateTransactionBody.Builder tokenUpdateTransactionBody = this.decodeTokenUpdate(call, addressIdConverter, nativeOperation);
        Tuple hederaToken = (Tuple)call.get(1);
        Bytes bytes = tokenMetadata = hederaToken.size() > 9 ? Bytes.wrap((byte[])((byte[])hederaToken.get(9))) : null;
        if (tokenMetadata != null && tokenMetadata.length() > 0L) {
            tokenUpdateTransactionBody.metadata(tokenMetadata);
        }
        List<TokenKeyWrapper> tokenKeys = this.decodeTokenKeys((Tuple[])hederaToken.get(7), addressIdConverter, nativeOperation);
        this.addKeys(tokenKeys, tokenUpdateTransactionBody);
        this.addMetaKey(tokenKeys, tokenUpdateTransactionBody);
        return tokenUpdateTransactionBody;
    }

    public TransactionBody decodeUpdateNFTsMetadata(@NonNull HtsCallAttempt attempt) {
        Tuple call = UpdateNFTsMetadataTranslator.UPDATE_NFTs_METADATA.decodeCall(attempt.input().toArrayUnsafe());
        TokenID tokenId = ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), (Address)call.get(0));
        List serialNumbers = Longs.asList((long[])((long[])call.get(1)));
        byte[] metadata = (byte[])call.get(2);
        TokenUpdateNftsTransactionBody.Builder txnBodyBuilder = TokenUpdateNftsTransactionBody.newBuilder().token(tokenId).serialNumbers(serialNumbers).metadata(Bytes.wrap((byte[])metadata));
        return TransactionBody.newBuilder().tokenUpdateNfts(txnBodyBuilder).build();
    }

    @Override
    @Nullable
    public TransactionBody decodeTokenUpdateKeys(@NonNull HtsCallAttempt attempt) {
        Tuple call = this.decodeCall(attempt);
        TokenID tokenId = ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), (Address)call.get(0));
        List<TokenKeyWrapper> tokenKeys = this.decodeTokenKeys((Tuple[])call.get(1), attempt.addressIdConverter(), attempt.nativeOperations());
        TokenUpdateTransactionBody.Builder txnBodyBuilder = TokenUpdateTransactionBody.newBuilder();
        txnBodyBuilder.token(tokenId);
        this.addKeys(tokenKeys, txnBodyBuilder);
        this.addMetaKey(tokenKeys, txnBodyBuilder);
        try {
            return TransactionBody.newBuilder().tokenUpdate(txnBodyBuilder).build();
        }
        catch (IllegalArgumentException ignore) {
            return null;
        }
    }

    private void addMetaKey(List<TokenKeyWrapper> tokenKeys, TokenUpdateTransactionBody.Builder builder) {
        tokenKeys.forEach(tokenKeyWrapper -> {
            Key key = tokenKeyWrapper.key().asGrpc();
            if (tokenKeyWrapper.isUsedForMetadataKey()) {
                builder.metadataKey(key);
            }
        });
    }
}

