/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.infra;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.HookEntityId;
import com.hedera.hapi.node.base.HookId;
import com.hedera.hapi.node.hooks.LambdaStorageSlot;
import com.hedera.hapi.node.hooks.LambdaStorageUpdate;
import com.hedera.hapi.node.state.contract.SlotKey;
import com.hedera.hapi.node.state.contract.SlotValue;
import com.hedera.hapi.node.state.hooks.LambdaSlotKey;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.state.ContractStateStore;
import com.hedera.node.app.service.contract.impl.state.StorageAccess;
import com.hedera.node.app.service.contract.impl.state.StorageAccesses;
import com.hedera.node.app.service.contract.impl.state.StorageSizeChange;
import com.hedera.node.app.service.contract.impl.state.WritableEvmHookStore;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tuweni.bytes.Bytes;

@Singleton
public class IterableStorageManager {
    private static final Logger log = LogManager.getLogger(IterableStorageManager.class);

    @Inject
    public IterableStorageManager() {
    }

    public void persistChanges(@NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull List<StorageAccesses> allAccesses, @NonNull List<StorageSizeChange> allSizeChanges, @NonNull ContractStateStore store, @NonNull WritableEvmHookStore writableEvmHookStore) {
        Set<LambdaSlotKey> slotKeys;
        HashMap firstKeys = new HashMap();
        ContractID hooksContract = enhancement.nativeOperations().entityIdFactory().newContractId(365L);
        allAccesses.forEach(contractAccesses -> contractAccesses.accesses().forEach(access -> {
            if (access.isUpdate()) {
                ContractID contractId = contractAccesses.contractID();
                if (contractId.equals((Object)hooksContract)) {
                    return;
                }
                com.hedera.pbj.runtime.io.buffer.Bytes firstContractKey = firstKeys.computeIfAbsent(contractId, cid -> this.contractFirstKeyOf(enhancement, contractId));
                com.hedera.pbj.runtime.io.buffer.Bytes newFirstContractKey = switch (StorageAccess.StorageAccessType.getAccessType(access)) {
                    default -> throw new MatchException(null, null);
                    case StorageAccess.StorageAccessType.UNKNOWN, StorageAccess.StorageAccessType.READ_ONLY, StorageAccess.StorageAccessType.UPDATE -> firstContractKey;
                    case StorageAccess.StorageAccessType.REMOVAL -> this.removeAccessedValue(store, firstContractKey, contractAccesses.contractID(), ConversionUtils.tuweniToPbjBytes((Bytes)access.key()));
                    case StorageAccess.StorageAccessType.ZERO_INTO_EMPTY_SLOT -> {
                        store.removeSlot(new SlotKey(contractAccesses.contractID(), ConversionUtils.tuweniToPbjBytes((Bytes)access.key())));
                        yield firstContractKey;
                    }
                    case StorageAccess.StorageAccessType.INSERTION -> this.insertAccessedValue(store, firstContractKey, ConversionUtils.tuweniToPbjBytes((Bytes)Objects.requireNonNull(access.writtenValue())), contractAccesses.contractID(), ConversionUtils.tuweniToPbjBytes((Bytes)access.key()));
                };
                firstKeys.put(contractAccesses.contractID(), newFirstContractKey);
            }
        }));
        long slotUsageChange = 0L;
        for (StorageSizeChange change : allSizeChanges) {
            if (change.contractID().equals((Object)hooksContract) || change.numInsertions() == 0 && change.numRemovals() == 0) continue;
            enhancement.operations().updateStorageMetadata(change.contractID(), firstKeys.getOrDefault(change.contractID(), com.hedera.pbj.runtime.io.buffer.Bytes.EMPTY), change.netChange());
            slotUsageChange += (long)change.netChange();
        }
        if (slotUsageChange != 0L) {
            store.adjustSlotCount(slotUsageChange);
        }
        if (!(slotKeys = writableEvmHookStore.getModifiedLambdaSlotKeys()).isEmpty()) {
            HookId hookId = null;
            ArrayList<LambdaStorageUpdate> updates = new ArrayList<LambdaStorageUpdate>();
            for (LambdaSlotKey modifiedKey : slotKeys) {
                hookId = modifiedKey.hookIdOrThrow();
                SlotValue value = writableEvmHookStore.getSlotValue(modifiedKey);
                LambdaStorageSlot slot = LambdaStorageSlot.newBuilder().value(WritableEvmHookStore.isAllZeroWord(Objects.requireNonNull(value).value()) ? com.hedera.pbj.runtime.io.buffer.Bytes.EMPTY : value.value()).key(modifiedKey.key()).build();
                updates.add(LambdaStorageUpdate.newBuilder().storageSlot(slot).build());
            }
            int slotsChanged = writableEvmHookStore.updateStorage(hookId, updates);
            if (slotsChanged != 0) {
                HookEntityId entityId = hookId.entityIdOrThrow();
                enhancement.operations().updateLambdaStorageSlots(entityId.accountIdOrThrow(), slotsChanged, false);
            }
        }
    }

    @NonNull
    private com.hedera.pbj.runtime.io.buffer.Bytes contractFirstKeyOf(@NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull ContractID contractID) {
        Account account = enhancement.nativeOperations().getAccount(contractID);
        return account != null ? account.firstContractStorageKey() : com.hedera.pbj.runtime.io.buffer.Bytes.EMPTY;
    }

    @NonNull
    private com.hedera.pbj.runtime.io.buffer.Bytes removeAccessedValue(@NonNull ContractStateStore store, @NonNull com.hedera.pbj.runtime.io.buffer.Bytes firstContractKey, @NonNull ContractID contractID, @NonNull com.hedera.pbj.runtime.io.buffer.Bytes key) {
        Objects.requireNonNull(firstContractKey);
        Objects.requireNonNull(contractID);
        Objects.requireNonNull(store);
        Objects.requireNonNull(key);
        SlotKey slotKey = new SlotKey(contractID, key);
        try {
            SlotValue slotValue = this.slotValueFor(store, slotKey, "Missing key ");
            com.hedera.pbj.runtime.io.buffer.Bytes nextKey = slotValue.nextKey();
            com.hedera.pbj.runtime.io.buffer.Bytes prevKey = slotValue.previousKey();
            if (!com.hedera.pbj.runtime.io.buffer.Bytes.EMPTY.equals((Object)nextKey)) {
                this.updatePrevFor(new SlotKey(contractID, nextKey), prevKey, store);
            }
            if (!com.hedera.pbj.runtime.io.buffer.Bytes.EMPTY.equals((Object)prevKey)) {
                this.updateNextFor(new SlotKey(contractID, prevKey), nextKey, store);
            }
            firstContractKey = key.equals((Object)firstContractKey) ? nextKey : firstContractKey;
        }
        catch (Exception irreparable) {
            log.error("Failed link management when removing {}; will be unable to expire all slots for contract {}", (Object)key, (Object)contractID, (Object)irreparable);
        }
        store.removeSlot(slotKey);
        return firstContractKey;
    }

    @NonNull
    private com.hedera.pbj.runtime.io.buffer.Bytes insertAccessedValue(@NonNull ContractStateStore store, @NonNull com.hedera.pbj.runtime.io.buffer.Bytes firstContractKey, @NonNull com.hedera.pbj.runtime.io.buffer.Bytes newValue, @NonNull ContractID contractID, @NonNull com.hedera.pbj.runtime.io.buffer.Bytes newKey) {
        Objects.requireNonNull(store);
        Objects.requireNonNull(newKey);
        Objects.requireNonNull(newValue);
        try {
            if (!com.hedera.pbj.runtime.io.buffer.Bytes.EMPTY.equals((Object)firstContractKey)) {
                this.updatePrevFor(new SlotKey(contractID, firstContractKey), newKey, store);
            }
        }
        catch (Exception irreparable) {
            log.error("Failed link management when inserting {}; will be unable to expire all slots for contract {}", (Object)newKey, (Object)contractID, (Object)irreparable);
        }
        store.putSlot(new SlotKey(contractID, newKey), new SlotValue(newValue, com.hedera.pbj.runtime.io.buffer.Bytes.EMPTY, firstContractKey));
        return newKey;
    }

    private void updatePrevFor(@NonNull SlotKey key, @NonNull com.hedera.pbj.runtime.io.buffer.Bytes newPrevKey, @NonNull ContractStateStore store) {
        SlotValue value = this.slotValueFor(store, key, "Missing next key ");
        store.putSlot(key, value.copyBuilder().previousKey(newPrevKey).build());
    }

    private void updateNextFor(@NonNull SlotKey key, @NonNull com.hedera.pbj.runtime.io.buffer.Bytes newNextKey, @NonNull ContractStateStore store) {
        SlotValue value = this.slotValueFor(store, key, "Missing prev key ");
        store.putSlot(key, value.copyBuilder().nextKey(newNextKey).build());
    }

    @NonNull
    private SlotValue slotValueFor(@NonNull ContractStateStore store, @NonNull SlotKey slotKey, @NonNull String msgOnError) {
        return Objects.requireNonNull(store.getSlotValue(slotKey), () -> msgOnError + String.valueOf(slotKey.key()));
    }
}

