/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.config.converter;

import com.hedera.node.config.types.LongPair;
import com.swirlds.config.api.converter.ConfigConverter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.regex.Pattern;

public class LongPairConverter
implements ConfigConverter<LongPair> {
    private static final String PATTERN = Pattern.quote("-");

    public LongPair convert(@NonNull String value) throws IllegalArgumentException, NullPointerException {
        Objects.requireNonNull(value, "Parameter 'value' cannot be null");
        String[] split = value.split(PATTERN, 2);
        if (split.length <= 1) {
            throw new IllegalArgumentException("Invalid long pair: " + value);
        }
        String left = split[0];
        String right = split[1];
        return new LongPair(Long.valueOf(left), Long.valueOf(right));
    }
}

