/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss;

import com.esaulpaugh.headlong.abi.Function;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.state.schedule.Schedule;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.CallAttemptOptions;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.spi.signatures.SignatureVerifier;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.Set;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;

public class HssCallAttempt
extends AbstractCallAttempt<HssCallAttempt> {
    public static final Function REDIRECT_FOR_SCHEDULE_TXN = new Function("redirectForScheduleTxn(address,bytes)");
    @Nullable
    private final Schedule redirectScheduleTxn;
    @NonNull
    private final SignatureVerifier signatureVerifier;

    public HssCallAttempt(@NonNull Bytes input, @NonNull CallAttemptOptions<HssCallAttempt> options, @NonNull SignatureVerifier signatureVerifier) {
        super(input, options, REDIRECT_FOR_SCHEDULE_TXN);
        this.redirectScheduleTxn = this.isRedirect() ? this.linkedSchedule(Objects.requireNonNull(this.redirectAddress)) : null;
        this.signatureVerifier = signatureVerifier;
    }

    @Override
    protected SystemContractMethod.SystemContract systemContractKind() {
        return SystemContractMethod.SystemContract.HSS;
    }

    @Override
    protected HssCallAttempt self() {
        return this;
    }

    @Nullable
    public Schedule redirectScheduleTxn() {
        if (!this.isRedirect()) {
            throw new IllegalStateException("Not an schedule transaction redirect");
        }
        return this.redirectScheduleTxn;
    }

    @Nullable
    public ScheduleID redirectScheduleId() {
        if (!this.isRedirect()) {
            throw new IllegalStateException("Not a schedule redirect");
        }
        return this.redirectScheduleTxn == null ? null : this.redirectScheduleTxn.scheduleId();
    }

    @Nullable
    public Schedule linkedSchedule(@NonNull Address scheduleAddress) {
        Objects.requireNonNull(scheduleAddress);
        if (ConversionUtils.isLongZero(scheduleAddress)) {
            return this.nativeOperations().getSchedule(this.nativeOperations().entityIdFactory().newScheduleId(ConversionUtils.numberOfLongZero(scheduleAddress.toArray())));
        }
        return null;
    }

    public Set<Key> keySetFor() {
        Account sender = this.nativeOperations().getAccount(this.senderId());
        Objects.requireNonNull(sender);
        if (sender.smartContract()) {
            return this.getKeysForContractSender();
        }
        return this.getKeysForEOASender();
    }

    @NonNull
    private Set<Key> getKeysForEOASender() {
        Key key = this.enhancement().systemOperations().maybeEthSenderKey();
        if (key != null) {
            return Set.of(key);
        }
        return this.nativeOperations().authorizingSimpleKeys();
    }

    @NonNull
    public Set<Key> getKeysForContractSender() {
        long contractNum = ConversionUtils.maybeMissingNumberOf(this.senderAddress(), this.nativeOperations());
        if (this.isOnlyDelegatableContractKeysActive()) {
            return Set.of(Key.newBuilder().delegatableContractId(this.enhancement().nativeOperations().entityIdFactory().newContractId(contractNum)).build());
        }
        return Set.of(Key.newBuilder().contractID(this.enhancement().nativeOperations().entityIdFactory().newContractId(contractNum)).build());
    }

    @NonNull
    public SignatureVerifier signatureVerifier() {
        return this.signatureVerifier;
    }
}

