/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkle.test.fixtures.map.benchmark;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;

public class RandomKeySet<T> {
    private final List<T> data = new ArrayList<T>();
    private Queue<Integer> gaps = new LinkedList<Integer>();
    private final HashMap<T, Integer> keyPositions = new HashMap();
    private int keyCount;

    public synchronized T getRandomKey(Random random) {
        if (this.keyCount == 0) {
            return null;
        }
        int size = this.data.size();
        int index = random.nextInt(size);
        T key = this.data.get(index);
        while (key == null) {
            index = (index + 1) % size;
            key = this.data.get(index);
        }
        return this.data.get(index);
    }

    public synchronized void add(T key) {
        if (this.keyPositions.containsKey(key)) {
            return;
        }
        if (key == null) {
            throw new IllegalArgumentException("null keys are not supported");
        }
        if (this.gaps.size() > 0) {
            int index = this.gaps.remove();
            this.data.set(index, key);
            this.keyPositions.put(key, index);
        } else {
            this.data.add(key);
            this.keyPositions.put(key, this.data.size() - 1);
        }
        ++this.keyCount;
    }

    public synchronized void remove(T key) {
        Integer index = this.keyPositions.get(key);
        if (index == null) {
            return;
        }
        this.data.set(index, null);
        this.gaps.add(index);
        this.keyPositions.remove(key);
        --this.keyCount;
    }

    public synchronized int size() {
        return this.keyCount;
    }
}

