/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform.nft;

import com.swirlds.base.utility.ToStringBuilder;
import java.io.IOException;
import java.util.Objects;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.exceptions.InvalidVersionException;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class NftId
implements SelfSerializable {
    public static final long CLASS_ID = 150810885712409683L;
    private static final int VERSION_ORIGINAL = 1;
    private long shardNum;
    private long realmNum;
    private long tokenNum;

    public NftId() {
    }

    public NftId(long shardNum, long realmNum, long tokenNum) {
        this.shardNum = shardNum;
        this.realmNum = realmNum;
        this.tokenNum = tokenNum;
    }

    private NftId(NftId nftId) {
        this.shardNum = nftId.shardNum;
        this.realmNum = nftId.realmNum;
        this.tokenNum = nftId.tokenNum;
    }

    public long getClassId() {
        return 150810885712409683L;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.shardNum);
        out.writeLong(this.realmNum);
        out.writeLong(this.tokenNum);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        if (version != 1) {
            throw new InvalidVersionException(1, version);
        }
        this.shardNum = in.readLong();
        this.realmNum = in.readLong();
        this.tokenNum = in.readLong();
    }

    public int getVersion() {
        return 1;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        NftId nftId = (NftId)other;
        return this.shardNum == nftId.shardNum && this.realmNum == nftId.realmNum && this.tokenNum == nftId.tokenNum;
    }

    public int hashCode() {
        return Objects.hash(this.shardNum, this.realmNum, this.tokenNum);
    }

    public long getShardNum() {
        return this.shardNum;
    }

    public long getRealmNum() {
        return this.realmNum;
    }

    public long getTokenNum() {
        return this.tokenNum;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("ShardNum", (Object)this.shardNum).append("RealmNum", (Object)this.realmNum).append("TokenNum", (Object)this.tokenNum).toString();
    }
}

