/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.io;

import com.swirlds.common.io.streams.DebuggableMerkleDataInputStream;
import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.common.io.streams.MerkleDataOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class InputOutputStream
implements AutoCloseable {
    private final ByteArrayOutputStream outByteStream = new ByteArrayOutputStream();
    private final MerkleDataOutputStream outStream = new MerkleDataOutputStream((OutputStream)this.outByteStream);
    private MerkleDataInputStream inStream;

    public MerkleDataOutputStream getOutput() {
        return this.outStream;
    }

    public void startReading() throws IOException {
        this.startReading(false, false);
    }

    public void startReading(boolean printBytes, boolean debug) throws IOException {
        this.outByteStream.flush();
        byte[] bytes = this.outByteStream.toByteArray();
        if (printBytes) {
            System.out.println(Arrays.toString(bytes));
        }
        this.inStream = debug ? new DebuggableMerkleDataInputStream((InputStream)new ByteArrayInputStream(bytes)) : new MerkleDataInputStream((InputStream)new ByteArrayInputStream(bytes));
        this.outByteStream.close();
        this.outStream.close();
    }

    public void printBytes() {
        System.out.println(Arrays.toString(this.outByteStream.toByteArray()));
    }

    public MerkleDataInputStream getInput() {
        return this.inStream;
    }

    @Override
    public void close() throws IOException {
        if (this.inStream != null) {
            this.inStream.close();
        }
        this.outStream.close();
        this.outByteStream.close();
    }
}

