/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network.communication.states;

import com.swirlds.platform.network.NetworkProtocolException;
import com.swirlds.platform.network.communication.NegotiationException;
import com.swirlds.platform.network.communication.NegotiationProtocols;
import com.swirlds.platform.network.communication.states.NegotiationState;
import com.swirlds.platform.network.communication.states.NegotiationStateWithDescription;
import com.swirlds.platform.network.communication.states.ProtocolNegotiated;
import com.swirlds.platform.network.protocol.PeerProtocol;
import java.io.IOException;
import java.io.OutputStream;

public class ReceivedInitiate
extends NegotiationStateWithDescription {
    private final NegotiationProtocols protocols;
    private final OutputStream byteOutput;
    private final ProtocolNegotiated stateNegotiated;
    private final NegotiationState sleep;
    private int protocolInitiated = Integer.MIN_VALUE;

    public ReceivedInitiate(NegotiationProtocols protocols, OutputStream byteOutput, ProtocolNegotiated stateNegotiated, NegotiationState sleep) {
        this.protocols = protocols;
        this.byteOutput = byteOutput;
        this.stateNegotiated = stateNegotiated;
        this.sleep = sleep;
    }

    public NegotiationState receivedInitiate(int protocolId) {
        this.protocolInitiated = protocolId;
        return this;
    }

    @Override
    public NegotiationState transition() throws NegotiationException, NetworkProtocolException, InterruptedException, IOException {
        PeerProtocol peerProtocol = this.protocols.getProtocol(this.protocolInitiated);
        if (peerProtocol.shouldAccept()) {
            try {
                this.byteOutput.write(254);
                this.byteOutput.flush();
            }
            catch (IOException ex) {
                peerProtocol.acceptFailed();
                throw ex;
            }
            this.stateNegotiated.runProtocol(peerProtocol);
            this.protocolInitiated = Integer.MIN_VALUE;
            this.setDescription("accepted protocol initiated by peer - " + peerProtocol.getProtocolName());
            return this.stateNegotiated;
        }
        this.byteOutput.write(253);
        this.byteOutput.flush();
        this.protocolInitiated = Integer.MIN_VALUE;
        this.setDescription("rejected protocol initiated by peer - " + peerProtocol.getProtocolName());
        return this.sleep;
    }
}

