/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.metrics.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;

public class AtomicDouble {
    private volatile long bits;
    private static final AtomicLongFieldUpdater<AtomicDouble> updater = AtomicLongFieldUpdater.newUpdater(AtomicDouble.class, "bits");

    public AtomicDouble(double initialValue) {
        this.bits = Double.doubleToRawLongBits(initialValue);
    }

    public AtomicDouble() {
    }

    public final double get() {
        return Double.longBitsToDouble(this.bits);
    }

    public final void set(double newValue) {
        this.bits = Double.doubleToRawLongBits(newValue);
    }

    public final double getAndSet(double newValue) {
        long newBits = Double.doubleToRawLongBits(newValue);
        return Double.longBitsToDouble(updater.getAndSet(this, newBits));
    }

    public final boolean compareAndSet(double expectedValue, double newValue) {
        long expectedBits = Double.doubleToRawLongBits(expectedValue);
        long newBits = Double.doubleToRawLongBits(newValue);
        return updater.compareAndSet(this, expectedBits, newBits);
    }

    public final double addAndGet(double delta) {
        return this.accumulateAndGet(delta, Double::sum);
    }

    public final double accumulateAndGet(double updateValue, @NonNull DoubleBinaryOperator accumulatorFunction) {
        Objects.requireNonNull(accumulatorFunction);
        return this.updateAndGet(oldValue -> accumulatorFunction.applyAsDouble(oldValue, updateValue));
    }

    public final double updateAndGet(@NonNull DoubleUnaryOperator updateFunction) {
        double currentVal;
        double nextVal;
        long next;
        long current;
        Objects.requireNonNull(updateFunction);
        while (!updater.compareAndSet(this, current = this.bits, next = Double.doubleToRawLongBits(nextVal = updateFunction.applyAsDouble(currentVal = Double.longBitsToDouble(current))))) {
        }
        return nextVal;
    }
}

