/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.utility.throttle;

import com.swirlds.common.utility.throttle.Throttle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class MultiThrottle {
    private final List<Throttle> throttles;

    public MultiThrottle() {
        this.throttles = new ArrayList<Throttle>();
    }

    public MultiThrottle(List<Throttle> throttles) {
        if (throttles == null) {
            throw new IllegalArgumentException("throttles cannot be null");
        }
        this.throttles = new ArrayList<Throttle>(throttles);
        this.sortThrottles();
    }

    public synchronized void addThrottle(Throttle throttle) {
        if (throttle == null) {
            throw new IllegalArgumentException("throttle cannot be null");
        }
        this.throttles.add(throttle);
        this.sortThrottles();
    }

    public synchronized boolean allow() {
        return this.allow(1.0);
    }

    public synchronized boolean allow(double amount) {
        for (Throttle throttle : this.throttles) {
            if (throttle.allow(amount)) continue;
            return false;
        }
        return true;
    }

    private void sortThrottles() {
        this.throttles.sort(Comparator.comparing(Throttle::getCapacity));
    }
}

