/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.transformers;

import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.component.framework.schedulers.TaskScheduler;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import com.swirlds.component.framework.wires.input.BindableInputWire;
import com.swirlds.component.framework.wires.input.InputWire;
import com.swirlds.component.framework.wires.output.OutputWire;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.Function;

public class WireTransformer<A, B> {
    private final BindableInputWire<A, B> inputWire;
    private final OutputWire<B> outputWire;

    public WireTransformer(@NonNull WiringModel model, @NonNull String transformerName, @NonNull String transformerInputName, @NonNull Function<A, B> transformer) {
        Objects.requireNonNull(transformer);
        TaskScheduler taskScheduler = model.schedulerBuilder(transformerName).withType(TaskSchedulerType.DIRECT_THREADSAFE).build();
        this.inputWire = taskScheduler.buildInputWire(transformerInputName);
        this.inputWire.bind(transformer);
        this.outputWire = taskScheduler.getOutputWire();
    }

    public WireTransformer(@NonNull WiringModel model, @NonNull String transformerName, @NonNull String transformerInputName) {
        TaskScheduler taskScheduler = model.schedulerBuilder(transformerName).withType(TaskSchedulerType.DIRECT_THREADSAFE).build();
        this.inputWire = taskScheduler.buildInputWire(transformerInputName);
        this.outputWire = taskScheduler.getOutputWire();
    }

    @NonNull
    public InputWire<A> getInputWire() {
        return this.inputWire;
    }

    @NonNull
    public OutputWire<B> getOutputWire() {
        return this.outputWire;
    }

    public void bind(@NonNull Function<A, B> transformer) {
        this.inputWire.bind(transformer);
    }
}

