/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.sync;

import com.swirlds.base.utility.Pair;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.test.fixtures.sync.LocalConnection;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicReference;
import org.hiero.consensus.model.node.NodeId;

@FunctionalInterface
public interface ConnectionFactory {
    public static final int DEFAULT_CONNECTION_BUFFER_SIZE = 8192;

    public static Pair<Connection, Connection> createLocalConnections(NodeId nodeA, NodeId nodeB) throws IOException {
        PipedInputStream inputStreamA = new PipedInputStream();
        PipedOutputStream outputStreamB = new PipedOutputStream(inputStreamA);
        PipedInputStream inputStreamB = new PipedInputStream();
        PipedOutputStream outputStreamA = new PipedOutputStream(inputStreamB);
        LocalConnection callerConnection = new LocalConnection(nodeA, nodeB, inputStreamA, outputStreamA, 8192, true);
        LocalConnection listenerConnection = new LocalConnection(nodeB, nodeA, inputStreamB, outputStreamB, 8192, false);
        return Pair.of((Object)callerConnection, (Object)listenerConnection);
    }

    public static Pair<Connection, Connection> createSocketConnections(NodeId nodeA, NodeId nodeB) throws IOException {
        int bufferSize = 128;
        String listenIP = "127.0.0.1";
        int listenPort = 30123;
        int timeout = 400;
        ServerSocket serverSocket = new ServerSocket();
        serverSocket.bind(new InetSocketAddress("127.0.0.1", 30123));
        serverSocket.setSoTimeout(400);
        AtomicReference acceptedSocket = new AtomicReference();
        Thread thread = new Thread(() -> {
            try {
                Socket socket = serverSocket.accept();
                acceptedSocket.set(socket);
                socket.setSoTimeout(400);
                socket.setSendBufferSize(128);
                socket.setReceiveBufferSize(128);
                serverSocket.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        thread.start();
        Socket clientSocket = new Socket();
        clientSocket.connect(new InetSocketAddress("127.0.0.1", 30123), 400);
        clientSocket.setSoTimeout(400);
        clientSocket.setSendBufferSize(128);
        clientSocket.setReceiveBufferSize(128);
        try {
            thread.join(400L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (thread.isAlive()) {
            throw new RuntimeException("Timed out waiting for the server socket thread to finish");
        }
        LocalConnection callerConnection = new LocalConnection(nodeA, nodeB, clientSocket.getInputStream(), clientSocket.getOutputStream(), 128, true);
        LocalConnection listenerConnection = new LocalConnection(nodeB, nodeA, ((Socket)acceptedSocket.get()).getInputStream(), ((Socket)acceptedSocket.get()).getOutputStream(), 128, false);
        return Pair.of((Object)callerConnection, (Object)listenerConnection);
    }

    public Pair<Connection, Connection> createConnections(NodeId var1, NodeId var2) throws IOException;
}

