/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.reconnect;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.config.StateConfig;
import com.swirlds.platform.state.service.PlatformStateUtils;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.platform.state.signed.SignedStateInvalidException;
import com.swirlds.platform.state.signed.SignedStateValidationData;
import com.swirlds.platform.state.signed.SignedStateValidator;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultSignedStateValidator
implements SignedStateValidator {
    private static final Logger logger = LogManager.getLogger(DefaultSignedStateValidator.class);
    private final int hashDepth;

    public DefaultSignedStateValidator(@NonNull PlatformContext platformContext) {
        this.hashDepth = ((StateConfig)platformContext.getConfiguration().getConfigData(StateConfig.class)).debugHashDepth();
    }

    @Override
    public void validate(SignedState signedState, Roster roster, SignedStateValidationData previousStateData) {
        this.throwIfOld(signedState, previousStateData);
        signedState.pruneInvalidSignatures(roster);
        signedState.throwIfNotVerifiable();
    }

    private void throwIfOld(SignedState signedState, SignedStateValidationData previousStateData) throws SignedStateInvalidException {
        MerkleNodeState state = signedState.getState();
        if (PlatformStateUtils.roundOf((State)state) < previousStateData.round() || PlatformStateUtils.consensusTimestampOf((State)state).isBefore(previousStateData.consensusTimestamp())) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "State is too old. Failed reconnect state:\n{}\nOriginal reconnect state:\n{}", (Object)PlatformStateUtils.getInfoString((State)state, this.hashDepth), (Object)previousStateData.getInfoString());
            throw new SignedStateInvalidException("Received signed state is for a round smaller than or a consensus earlier than what we started with. Original round %d, received round %d. Original timestamp %s, received timestamp %s.".formatted(previousStateData.round(), signedState.getRound(), previousStateData.consensusTimestamp(), signedState.getConsensusTimestamp()));
        }
    }
}

