/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.testreader;

import com.swirlds.common.formatting.UnitFormatter;
import com.swirlds.common.units.TimeUnit;
import com.swirlds.common.units.Unit;
import com.swirlds.platform.testreader.JrsReportData;
import com.swirlds.platform.testreader.JrsTestIdentifier;
import com.swirlds.platform.testreader.JrsTestMetadata;
import com.swirlds.platform.testreader.JrsTestReportRow;
import com.swirlds.platform.testreader.JrsTestResult;
import com.swirlds.platform.testreader.TestStatus;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class JrsTestReportGenerator {
    private JrsTestReportGenerator() {
    }

    private static String generateWebBrowserUrl(@NonNull String testDirectory, @NonNull String bucketPrefix, @NonNull String bucketPrefixReplacement) {
        return testDirectory.replace(bucketPrefix, bucketPrefixReplacement);
    }

    private static void generateHyperlink(@NonNull StringBuilder sb, @NonNull String text, @NonNull String url) {
        sb.append("<a target=\"_blank\" href=\"%s\">%s</a>".formatted(url, text));
    }

    private static void generateColoredHyperlink(@NonNull StringBuilder sb, @NonNull String text, @NonNull String url, @NonNull String color) {
        sb.append("<a target=\"_blank\" style=\"color: %s\" href=\"%s\">%s</a>".formatted(color, url, text));
    }

    private static void generateTitle(@NonNull StringBuilder sb, @NonNull Instant now) {
        sb.append("<title>").append("JRS Test Report: ").append(now).append("</title>\n");
    }

    private static void generatePageStyle(@NonNull StringBuilder sb) {
        LocalDate currentDate = LocalDate.now();
        boolean april2 = currentDate.getMonth().equals(Month.APRIL) && currentDate.getDayOfMonth() == 2;
        String font = april2 ? "Snell Roundhand, cursive" : "Jetbrains Mono, monospace";
        sb.append("<style>\n    body {\n        font-family: %s;\n        font-size: 14px;\n        color: #bdbfc4;\n        background-color: #1e1e23;\n    }\n    .testDataTable > tbody > tr > th {\n        position: sticky;\n        top: 0;\n        border: 2px #AAAAAA solid;\n        padding: 3px;\n        background-color: #1e1e23;\n        font-size: 16px;\n        color: #DDDDDD;\n    }\n    .testDataTable > tbody > tr > td {\n        border: 1px #555555 solid;\n        padding: 10px;\n    }\n    .testDataTable > tbody > tr:hover td {\n        border: 3px solid gray;\n        padding: 8px;\n    }\n    .testDataTable > tbody > tr > td:hover {\n        border-color: #DDDDDD;\n    }\n    .sidePanel {\n        position: sticky;\n        top: 12px;\n    }\n    .topLevelTable > tbody > tr > td {\n        border: none;\n    }\n    .overview > tbody > tr > td {\n        border: none;\n        padding-left: 5px;\n        padding-right: 5px;\n        vertical-align: top;\n    }\n    .statusCell {\n        color: black;\n    }\n    .important {\n        color: #aea85d;\n    }\n    a:link {\n        color: #538af7;\n    }\n    a:visited {\n        color: #a64dff;\n    }\n    a:hover {\n        color: #aea85d;\n    }\n    a:link.passLink {\n        color: #3cb371;\n    }\n    a:visited.passLink {\n        color: #267349;\n    }\n    a:hover.passLink {\n        color: #aea85d;\n    }\n    a:link.failLink {\n        color: #f0524f;\n    }\n    a:visited.failLink {\n        color: #d31612;\n    }\n    a:hover.failLink {\n        color: #aea85d;\n    }\n    a:link.unknownLink {\n        color: slateBlue;\n    }\n    a:hover.unknownLink {\n        color: slateBlue;\n    }\n    .leftColumn {\n        vertical-align: top;\n        horizontal-align: right;\n        width: 75%%\n    }\n    .rightColumn {\n        vertical-align: top;\n        horizontal-align: left;\n        width: 25%%\n    }\n</style>\n".formatted(font));
    }

    private static void generateJavascript(@NonNull StringBuilder sb) {
        sb.append("<script>\n    function onLoad() {\n        registerClickListeners();\n        colorAllTableRows();\n    }\n    function registerClickListeners() {\n        registerClickListenersForTable('table_sortedByName');\n        registerClickListenersForTable('table_sortedByAge');\n        registerClickListenersForTable('table_sortedByStatus');\n    }\n    var previouslySelectedRow = null;\n    function registerClickListenersForTable(tableName) {\n        var table = document.getElementById(tableName);\n        for (var i = 1; i < table.rows.length; i++) {\n            var row = table.rows[i];\n            for (var j = 0; j < row.cells.length; j++) {\n                var cell = row.cells[j];\n                cell.onclick = (function() {\n                    if (previouslySelectedRow == this) {\n                        return;\n                    }\n                    for (var k = 0; k < this.cells.length; k++) {\n                        this.cells[k].style.borderBottomColor = \"#f0524f\";\n                    }\n                    if (previouslySelectedRow != null) {\n                        for (var k = 0; k < previouslySelectedRow.cells.length; k++) {\n                            previouslySelectedRow.cells[k].style.borderBottomColor = \"\";\n                        }\n                    }\n                    previouslySelectedRow = this;\n                }).bind(row);\n            }\n        }\n    }\n    function sortByName() {\n        document.getElementById('table_sortedByName').style.display = \"block\";\n        document.getElementById('table_sortedByAge').style.display = \"none\";\n        document.getElementById('table_sortedByStatus').style.display = \"none\";\n    }\n    function sortByAge() {\n        document.getElementById('table_sortedByName').style.display = \"none\";\n        document.getElementById('table_sortedByAge').style.display = \"block\";\n        document.getElementById('table_sortedByStatus').style.display = \"none\";\n    }\n    function sortByStatus() {\n        document.getElementById('table_sortedByName').style.display = \"none\";\n        document.getElementById('table_sortedByAge').style.display = \"none\";\n        document.getElementById('table_sortedByStatus').style.display = \"block\";\n    }\n    function showOverviewForOwner(owner) {\n        var overviews = document.getElementsByClassName('overview');\n        var desiredOverview = \"overview_\" + owner;\n        for (var i = 0; i < overviews.length; i++) {\n            if (overviews[i].id == desiredOverview) {\n                overviews[i].style.display = \"block\";\n            } else {\n                overviews[i].style.display = \"none\";\n            }\n        }\n    }\n    function showInTableIfOwnedBy(owner, tableId) {\n        var table = document.getElementById(tableId);\n        for (var i = 1, row; row = table.rows[i]; i++) {\n            // owner is in column 2\n            var rowOwner = row.cells[2].innerHTML;\n            if (rowOwner == owner) {\n                row.style.display = \"table-row\";\n            } else {\n                row.style.display = \"none\";\n            }\n        }\n    }\n    function showIfOwnedBy(owner) {\n        showInTableIfOwnedBy(owner, 'table_sortedByName');\n        showInTableIfOwnedBy(owner, 'table_sortedByAge');\n        showInTableIfOwnedBy(owner, 'table_sortedByStatus');\n    }\n    function showAllRowsInTable(tableId) {\n        var table = document.getElementById(tableId);\n        for (var i = 1, row; row = table.rows[i]; i++) {\n            row.style.display = \"table-row\";\n        }\n    }\n    function showAllRows() {\n        showAllRowsInTable('table_sortedByName');\n        showAllRowsInTable('table_sortedByAge');\n        showAllRowsInTable('table_sortedByStatus');\n    }\n    function switchToOwnerView(owner) {\n        if (owner == \"all\") {\n            showAllRows();\n            showOverviewForOwner(\"all\");\n        } else if (owner == \"\") {\n            showIfOwnedBy(\"\");\n            showOverviewForOwner(\"unassigned\");\n        } else {\n            showIfOwnedBy(owner);\n            showOverviewForOwner(owner);\n        }\n        colorAllTableRows();\n    }\n    function colorTableRows(tableId) {\n        var table = document.getElementById(tableId);\n        var light = true;\n        for (var i = 1, row; row = table.rows[i]; i++) {\n            if (row.style.display == \"none\") {\n                continue;\n            }\n            if (light) {\n                row.style.backgroundColor = \"#2f2f37\";\n            } else {\n                row.style.backgroundColor = \"#1e1e23\";\n            }\n            light = !light;\n        }\n    }\n    function colorAllTableRows() {\n        colorTableRows('table_sortedByName');\n        colorTableRows('table_sortedByAge');\n        colorTableRows('table_sortedByStatus');\n    }\n</script>\n");
    }

    private static void generateHeader(@NonNull StringBuilder sb, @NonNull Instant now) {
        sb.append("<head>\n");
        JrsTestReportGenerator.generateTitle(sb, now);
        JrsTestReportGenerator.generatePageStyle(sb);
        JrsTestReportGenerator.generateJavascript(sb);
        sb.append("</head>\n");
    }

    private static void generatePanelCell(@NonNull StringBuilder sb, @NonNull String panelName) {
        sb.append("<td>").append(panelName).append("</td>\n");
    }

    private static void generateNameCell(@NonNull StringBuilder sb, @NonNull String testName) {
        sb.append("<td class=\"important\">%s</td>\n".formatted(testName));
    }

    private static void generateOwnerCell(@NonNull StringBuilder sb, @NonNull String owner) {
        sb.append("<td>").append(owner).append("</td>\n");
    }

    private static void generateAgeCell(@NonNull StringBuilder sb, @NonNull Instant now, @NonNull Instant testTime) {
        Duration testAge = Duration.between(testTime, now);
        String ageString = new UnitFormatter(testAge.toMillis(), (Unit)TimeUnit.UNIT_MILLISECONDS).setShowSpaceInBetween(false).setAbbreviate(true).render();
        sb.append("<td>").append(ageString).append("</td>\n");
    }

    private static void generateStatusCell(@NonNull StringBuilder sb, @NonNull TestStatus status) {
        String statusColor = status == TestStatus.PASS ? "#3cb371" : (status == TestStatus.FAIL ? "#f0524f" : "slateBlue");
        sb.append("<td class=\"statusCell\" bgcolor=\"%s\"><center>%s</center></td>\n".formatted(statusColor, status.name()));
    }

    private static void generateHistoryCell(@NonNull StringBuilder sb, @NonNull List<JrsTestResult> historicalResults, @NonNull String bucketPrefix, @NonNull String bucketPrefixReplacement) {
        sb.append("<td>");
        for (int index = 1; index < historicalResults.size(); ++index) {
            String linkClass;
            String resultString;
            JrsTestResult result = historicalResults.get(index);
            String testUrl = JrsTestReportGenerator.generateWebBrowserUrl(result.testDirectory(), bucketPrefix, bucketPrefixReplacement);
            if (result.status() == TestStatus.PASS) {
                resultString = "P";
                linkClass = "passLink";
            } else if (result.status() == TestStatus.FAIL) {
                resultString = "F";
                linkClass = "failLink";
            } else {
                resultString = "?";
                linkClass = "unknownLink";
            }
            sb.append("<a class=\"%s\" href=\"%s\" target=\"_blank\">%s</a>".formatted(linkClass, testUrl, resultString));
        }
        sb.append("</td>\n");
    }

    private static void generateSummaryCell(@NonNull StringBuilder sb, @NonNull String testUrl) {
        sb.append("<td>");
        JrsTestReportGenerator.generateHyperlink(sb, "summary", testUrl + "summary.txt");
        sb.append("</td>\n");
    }

    private static void generateLogsCell(@NonNull StringBuilder sb, @NonNull String testUrl) {
        sb.append("<td>");
        JrsTestReportGenerator.generateHyperlink(sb, "logs", testUrl + "swirlds-logs.html");
        sb.append("</td>\n");
    }

    private static void generateMetricsCell(@NonNull StringBuilder sb, @NonNull String testUrl) {
        sb.append("<td>");
        JrsTestReportGenerator.generateHyperlink(sb, "metrics", testUrl + "multipage_pdf.pdf");
        sb.append("</td>\n");
    }

    private static void generateDataCell(@NonNull StringBuilder sb, @NonNull String testUrl) {
        sb.append("<td>");
        JrsTestReportGenerator.generateHyperlink(sb, "data", testUrl);
        sb.append("</td>\n");
    }

    private static void generateNotesCell(@NonNull StringBuilder sb, @NonNull String notesUrl) {
        sb.append("<td>");
        if (!notesUrl.isBlank()) {
            JrsTestReportGenerator.generateHyperlink(sb, "notes", notesUrl);
        }
        sb.append("</td>\n");
    }

    private static void generateTableRow(@NonNull StringBuilder sb, @NonNull JrsTestReportRow row, @NonNull Instant now, @NonNull String bucketPrefix, @NonNull String bucketPrefixReplacement) {
        String testUrl = JrsTestReportGenerator.generateWebBrowserUrl(row.getMostRecentTest().testDirectory(), bucketPrefix, bucketPrefixReplacement);
        sb.append("<tr>\n");
        JrsTestReportGenerator.generatePanelCell(sb, row.getMostRecentTest().id().panel());
        JrsTestReportGenerator.generateNameCell(sb, row.getMostRecentTest().id().name());
        JrsTestReportGenerator.generateOwnerCell(sb, row.metadata() == null ? "" : row.metadata().owner());
        JrsTestReportGenerator.generateAgeCell(sb, now, row.getMostRecentTest().timestamp());
        JrsTestReportGenerator.generateStatusCell(sb, row.getMostRecentTest().status());
        JrsTestReportGenerator.generateHistoryCell(sb, row.tests(), bucketPrefix, bucketPrefixReplacement);
        JrsTestReportGenerator.generateSummaryCell(sb, testUrl);
        JrsTestReportGenerator.generateLogsCell(sb, testUrl);
        JrsTestReportGenerator.generateMetricsCell(sb, testUrl);
        JrsTestReportGenerator.generateDataCell(sb, testUrl);
        JrsTestReportGenerator.generateNotesCell(sb, row.metadata() == null ? "" : row.metadata().notesUrl());
        sb.append("</tr>\n");
    }

    private static void generateTable(@NonNull StringBuilder sb, @NonNull String tableId, @NonNull List<JrsTestReportRow> rows, @NonNull Instant now, @NonNull String bucketPrefix, @NonNull String bucketPrefixReplacement, @NonNull Comparator<JrsTestReportRow> comparator, boolean hidden) {
        rows.sort(comparator);
        sb.append("<table id=\"%s\" style=\"display: %s\" class=\"testDataTable\" align=\"right\">\n    <tr>\n        <th>Panel</th>\n        <th>Test Name</th>\n        <th>Owner</th>\n        <th>Age</th>\n        <th>Status</th>\n        <th>History</th>\n        <th>Summary</th>\n        <th>Logs</th>\n        <th>Metrics</th>\n        <th>Data</th>\n        <th>Notes</th>\n    </tr>\n".formatted(tableId, hidden ? "none" : "block"));
        for (JrsTestReportRow row : rows) {
            JrsTestReportGenerator.generateTableRow(sb, row, now, bucketPrefix, bucketPrefixReplacement);
        }
        sb.append("</table>\n");
    }

    private static int statusComparator(@NonNull JrsTestReportRow a, @NonNull JrsTestReportRow b) {
        JrsTestResult aResult = a.getMostRecentTest();
        JrsTestResult bResult = b.getMostRecentTest();
        if (aResult.status() != bResult.status()) {
            return Integer.compare(aResult.status().ordinal(), bResult.status().ordinal());
        }
        if (aResult.status() == TestStatus.PASS) {
            int mostRecentFailureA = Integer.MAX_VALUE;
            for (int index = 1; index < a.tests().size(); ++index) {
                if (a.tests().get(index).status() == TestStatus.PASS) continue;
                mostRecentFailureA = index;
                break;
            }
            int mostRecentFailureB = Integer.MAX_VALUE;
            for (int index = 1; index < b.tests().size(); ++index) {
                if (b.tests().get(index).status() == TestStatus.PASS) continue;
                mostRecentFailureB = index;
                break;
            }
            if (mostRecentFailureA != mostRecentFailureB) {
                return Integer.compare(mostRecentFailureA, mostRecentFailureB);
            }
        } else {
            int mostRecentPassA = Integer.MAX_VALUE;
            for (int index = 1; index < a.tests().size(); ++index) {
                if (a.tests().get(index).status() != TestStatus.PASS) continue;
                mostRecentPassA = index;
                break;
            }
            int mostRecentPassB = Integer.MAX_VALUE;
            for (int index = 1; index < b.tests().size(); ++index) {
                if (b.tests().get(index).status() != TestStatus.PASS) continue;
                mostRecentPassB = index;
                break;
            }
            if (mostRecentPassA != mostRecentPassB) {
                return Integer.compare(mostRecentPassA, mostRecentPassB);
            }
        }
        return aResult.id().compareTo(bResult.id());
    }

    private static int ageComparator(@NonNull JrsTestReportRow a, @NonNull JrsTestReportRow b) {
        if (!a.getMostRecentTest().timestamp().equals(b.getMostRecentTest().timestamp())) {
            return b.getMostRecentTest().timestamp().compareTo(a.getMostRecentTest().timestamp());
        }
        return a.getMostRecentTest().id().compareTo(b.getMostRecentTest().id());
    }

    private static void generateDataTable(@NonNull StringBuilder sb, @NonNull JrsReportData data, @NonNull Map<JrsTestIdentifier, JrsTestMetadata> metadata, @NonNull Instant now, @NonNull String bucketPrefix, @NonNull String bucketPrefixReplacement) {
        List<JrsTestReportRow> rows = JrsTestReportGenerator.buildTableRows(data.testResults(), metadata);
        JrsTestReportGenerator.generateTable(sb, "table_sortedByName", rows, now, bucketPrefix, bucketPrefixReplacement, Comparator.comparing(a -> a.getMostRecentTest().id()), false);
        JrsTestReportGenerator.generateTable(sb, "table_sortedByAge", rows, now, bucketPrefix, bucketPrefixReplacement, JrsTestReportGenerator::ageComparator, true);
        JrsTestReportGenerator.generateTable(sb, "table_sortedByStatus", rows, now, bucketPrefix, bucketPrefixReplacement, JrsTestReportGenerator::statusComparator, true);
    }

    @NonNull
    private static TestCount countTestsForOwner(@NonNull List<JrsTestResult> results, @NonNull Map<JrsTestIdentifier, JrsTestMetadata> metadata, @NonNull String owner) {
        HashMap<JrsTestIdentifier, List> resultsByTestType = new HashMap<JrsTestIdentifier, List>();
        for (JrsTestResult result : results) {
            JrsTestIdentifier id = result.id();
            if (!owner.equals("all")) {
                String ownerFromMetadata;
                JrsTestMetadata testMetadata = metadata.get(id);
                String string = ownerFromMetadata = testMetadata == null ? "" : testMetadata.owner();
                if (!owner.equals(ownerFromMetadata)) continue;
            }
            List resultsForType = resultsByTestType.computeIfAbsent(id, k -> new ArrayList());
            resultsForType.add(result);
        }
        for (List tests : resultsByTestType.values()) {
            Collections.sort(tests);
        }
        int uniqueTests = resultsByTestType.size();
        int passingTests = 0;
        int failingTests = 0;
        int unknownTests = 0;
        for (JrsTestIdentifier testIdentifier : resultsByTestType.keySet()) {
            List testResults = (List)resultsByTestType.get(testIdentifier);
            JrsTestResult mostRecentResult = (JrsTestResult)testResults.get(0);
            if (mostRecentResult.status() == TestStatus.PASS) {
                ++passingTests;
                continue;
            }
            if (mostRecentResult.status() == TestStatus.FAIL) {
                ++failingTests;
                continue;
            }
            ++unknownTests;
        }
        return new TestCount(uniqueTests, passingTests, failingTests, unknownTests);
    }

    private static Map<String, TestCount> countTests(@NonNull List<JrsTestResult> results, @NonNull Map<JrsTestIdentifier, JrsTestMetadata> metadata, @NonNull List<String> owners) {
        HashMap<String, TestCount> testCountMap = new HashMap<String, TestCount>();
        for (String owner : owners) {
            testCountMap.put(owner, JrsTestReportGenerator.countTestsForOwner(results, metadata, owner));
        }
        if (!testCountMap.containsKey("")) {
            testCountMap.put("", JrsTestReportGenerator.countTestsForOwner(results, metadata, ""));
        }
        if (!testCountMap.containsKey("all")) {
            testCountMap.put("all", JrsTestReportGenerator.countTestsForOwner(results, metadata, "all"));
        }
        return testCountMap;
    }

    private static void generateOverview(@NonNull StringBuilder sb, @NonNull JrsReportData data, @NonNull String owner, @NonNull TestCount testCount, boolean hidden) {
        LocalDate localDate = data.reportTime().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalTime localTime = data.reportTime().atZone(ZoneId.systemDefault()).toLocalTime();
        ZonedDateTime zonedDateTime = ZonedDateTime.of(localDate, localTime, ZoneId.systemDefault());
        String date = DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL).format(zonedDateTime);
        String time = DateTimeFormatter.ofLocalizedTime(FormatStyle.FULL).format(zonedDateTime).replace("\u202f", " ");
        int percentPassing = testCount.uniqueTests() == 0 ? -1 : (int)(100.0 * (double)testCount.passingTests() / (double)testCount.uniqueTests());
        CharSequence[] directoryParts = data.directory().split("/");
        String lastDirectory = directoryParts[directoryParts.length - 1];
        String formattedLastDirectory = "<font color=\"#f0524f\">" + lastDirectory + "</font>";
        directoryParts[directoryParts.length - 1] = formattedLastDirectory;
        String formattedDirectory = String.join((CharSequence)"/", directoryParts);
        sb.append("<table id=\"overview_%s\" style=\"display: %s\" class=\"overview\">\n    <tr>\n        <td class=\"important\">Directory</td>\n        <td>%s</td>\n    </tr>\n    <tr>\n        <td class=\"important\">Date</td>\n        <td>%s</td>\n    </tr>\n    <tr>\n        <td class=\"important\">Time</td>\n        <td>%s</td>\n    </tr>\n    <tr>\n        <td class=\"important\">Span</td>\n        <td>%s days</td>\n    </tr>\n    <tr>\n        <td class=\"important\">Pass Rate</td>\n        <td>%s%%</td>\n    </tr>\n    <tr>\n        <td class=\"important\">Total</td>\n        <td>%s</td>\n    </tr>\n    <tr>\n        <td class=\"important\">Passing</td>\n        <td>%s</td>\n    </tr>\n    <tr>\n        <td class=\"important\">Failing</td>\n        <td>%s</td>\n    </tr>\n    <tr>\n        <td class=\"important\">Unknown</td>\n        <td>%s</td>\n    </tr>\n</table>\n".formatted(owner, hidden ? "none" : "block", formattedDirectory, date, time, data.reportSpan(), percentPassing == -1 ? "--" : Integer.valueOf(percentPassing), testCount.uniqueTests(), testCount.passingTests(), testCount.failingTests(), testCount.unknownTests()));
    }

    private static void generateOverviews(@NonNull StringBuilder sb, @NonNull JrsReportData data, @NonNull List<String> owners, @NonNull Map<String, TestCount> testCountMap) {
        JrsTestReportGenerator.generateOverview(sb, data, "all", testCountMap.get("all"), false);
        JrsTestReportGenerator.generateOverview(sb, data, "unassigned", testCountMap.get(""), true);
        for (String owner : owners) {
            JrsTestReportGenerator.generateOverview(sb, data, owner, testCountMap.get(owner), true);
        }
    }

    private static void generateOrderControls(@NonNull StringBuilder sb) {
        sb.append("<center><h1><b>Ordering</b></h1></center>\n<form autocomplete=\"off\">\n    <input type=\"radio\" name=\"order\" onclick=\"sortByName()\" checked> <span class=\"important\">name</span><br>\n    <input type=\"radio\" name=\"order\" onclick=\"sortByAge()\"> <span class=\"important\">age</span><br>\n    <input type=\"radio\" name=\"order\" onclick=\"sortByStatus()\"> <span class=\"important\">status</span><br>\n</form>\n");
    }

    private static void generateOwnerControls(@NonNull StringBuilder sb, @NonNull List<String> owners, @NonNull Map<String, TestCount> testCountMap) {
        sb.append("<center><h1><b>Owner</b></h1></center>\n<form autocomplete=\"off\">\n<input type=\"radio\" name=\"order\" value=\"name\" onclick=\"switchToOwnerView('all')\" checked> <span class=\"important\">all</span> (%s)<br>\n<input type=\"radio\" name=\"order\" value=\"age\" onclick=\"switchToOwnerView('')\"> <span class=\"important\">unassigned</span> (%s)<br>\n".formatted(testCountMap.get("all").uniqueTests(), testCountMap.get("").uniqueTests()));
        for (String owner : owners) {
            sb.append("<input type=\"radio\" name=\"order\" value=\"status\" onclick=\"switchToOwnerView('%s')\"> <span class=\"important\">%s</span> (%s)<br>\n".formatted(owner, owner, testCountMap.get(owner).uniqueTests()));
        }
        sb.append("</form>\n");
    }

    @NonNull
    private static List<String> findOwners(@NonNull JrsReportData data, @NonNull Map<JrsTestIdentifier, JrsTestMetadata> metadata) {
        HashSet<String> owners = new HashSet<String>();
        for (JrsTestResult result : data.testResults()) {
            JrsTestMetadata testMetadata = metadata.get(result.id());
            if (testMetadata == null || testMetadata.owner().isBlank()) continue;
            owners.add(testMetadata.owner());
        }
        ArrayList<String> ownerList = new ArrayList<String>(owners);
        ownerList.sort(String::compareTo);
        return ownerList;
    }

    private static void generateSidePanel(@NonNull StringBuilder sb, @NonNull JrsReportData data, @NonNull Map<JrsTestIdentifier, JrsTestMetadata> metadata) {
        List<String> owners = JrsTestReportGenerator.findOwners(data, metadata);
        Map<String, TestCount> testCountMap = JrsTestReportGenerator.countTests(data.testResults(), metadata, owners);
        sb.append("<div class=\"sidePanel\">\n");
        JrsTestReportGenerator.generateOverviews(sb, data, owners, testCountMap);
        sb.append("<br><hr>");
        JrsTestReportGenerator.generateOrderControls(sb);
        sb.append("<br><hr>");
        JrsTestReportGenerator.generateOwnerControls(sb, owners, testCountMap);
        sb.append("</div>\n");
    }

    private static void generateBody(@NonNull StringBuilder sb, @NonNull JrsReportData data, @NonNull Map<JrsTestIdentifier, JrsTestMetadata> metadata, @NonNull Instant now, @NonNull String bucketPrefix, @NonNull String bucketPrefixReplacement) {
        sb.append("<center>\n<table class=\"topLevelTable\">\n<tr>\n<td class=\"leftColumn\">\n");
        JrsTestReportGenerator.generateDataTable(sb, data, metadata, now, bucketPrefix, bucketPrefixReplacement);
        sb.append("</td>\n<td class=\"rightColumn\">\n");
        JrsTestReportGenerator.generateSidePanel(sb, data, metadata);
        sb.append("</td>\n</tr>\n</table>\n</center>\n");
    }

    private static void generatePage(@NonNull StringBuilder sb, @NonNull JrsReportData data, @NonNull Map<JrsTestIdentifier, JrsTestMetadata> metadata, @NonNull Instant now, @NonNull String bucketPrefix, @NonNull String bucketPrefixReplacement) {
        sb.append("<!DOCTYPE html>\n");
        sb.append("<html>\n");
        JrsTestReportGenerator.generateHeader(sb, now);
        sb.append("<body onload=\"onLoad()\">\n");
        JrsTestReportGenerator.generateBody(sb, data, metadata, now, bucketPrefix, bucketPrefixReplacement);
        sb.append("</body>\n");
        sb.append("</html>\n");
    }

    public static void validateMetadata(@NonNull Set<JrsTestIdentifier> tests, @NonNull Map<JrsTestIdentifier, JrsTestMetadata> metadata) {
        StringBuilder sb;
        HashSet<JrsTestIdentifier> unassignedMetadata = new HashSet<JrsTestIdentifier>(metadata.keySet());
        ArrayList<JrsTestIdentifier> testsWithoutMetadata = new ArrayList<JrsTestIdentifier>();
        for (JrsTestIdentifier test : tests) {
            boolean noteFound = unassignedMetadata.remove(test);
            if (noteFound) continue;
            testsWithoutMetadata.add(test);
        }
        if (!testsWithoutMetadata.isEmpty()) {
            sb = new StringBuilder();
            sb.append("The following test(s) do not have metadata:\n");
            for (JrsTestIdentifier test : testsWithoutMetadata) {
                sb.append("  - ").append(test.panel()).append(": ").append(test.name()).append("\n");
            }
            System.out.println(sb);
        }
        if (!unassignedMetadata.isEmpty()) {
            sb = new StringBuilder();
            sb.append("There is metadata defined for the following test(s), but these test(s) were not discovered during scan:\n");
            for (JrsTestIdentifier test : unassignedMetadata) {
                sb.append("  - ").append(test.panel()).append(": ").append(test.name()).append("\n");
            }
            System.out.println(sb);
        }
    }

    @NonNull
    private static List<JrsTestReportRow> buildTableRows(@NonNull List<JrsTestResult> results, @NonNull Map<JrsTestIdentifier, JrsTestMetadata> metadata) {
        HashMap<JrsTestIdentifier, List> resultsByTestType = new HashMap<JrsTestIdentifier, List>();
        for (JrsTestResult result : results) {
            JrsTestIdentifier id = result.id();
            List resultsForType = resultsByTestType.computeIfAbsent(id, k -> new ArrayList());
            resultsForType.add(result);
        }
        for (List tests : resultsByTestType.values()) {
            Collections.sort(tests);
        }
        ArrayList<JrsTestReportRow> rows = new ArrayList<JrsTestReportRow>();
        for (JrsTestIdentifier testType : resultsByTestType.keySet()) {
            rows.add(new JrsTestReportRow((List)resultsByTestType.get(testType), metadata.getOrDefault(testType, null)));
        }
        JrsTestReportGenerator.validateMetadata(resultsByTestType.keySet(), metadata);
        return rows;
    }

    public static void generateReport(@NonNull JrsReportData data, @NonNull Map<JrsTestIdentifier, JrsTestMetadata> metadata, @NonNull Instant now, @NonNull String bucketPrefix, @NonNull String bucketPrefixReplacement, @NonNull Path outputFile) {
        StringBuilder sb = new StringBuilder();
        JrsTestReportGenerator.generatePage(sb, data, metadata, now, bucketPrefix, bucketPrefixReplacement);
        String reportString = sb.toString();
        try {
            Files.write(outputFile, reportString.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("unable to generate test report", e);
        }
    }

    private record TestCount(int uniqueTests, int passingTests, int failingTests, int unknownTests) {
    }
}

