/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.wiring;

import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.component.framework.component.ComponentWiring;
import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerConfiguration;
import com.swirlds.platform.builder.PlatformComponentBuilder;
import com.swirlds.platform.components.AppNotifier;
import com.swirlds.platform.components.EventWindowManager;
import com.swirlds.platform.components.SavedStateController;
import com.swirlds.platform.components.appcomm.CompleteStateNotificationWithCleanup;
import com.swirlds.platform.components.appcomm.LatestCompleteStateNotifier;
import com.swirlds.platform.event.branching.BranchDetector;
import com.swirlds.platform.event.branching.BranchReporter;
import com.swirlds.platform.event.deduplication.EventDeduplicator;
import com.swirlds.platform.event.orphan.OrphanBuffer;
import com.swirlds.platform.event.preconsensus.InlinePcesWriter;
import com.swirlds.platform.event.preconsensus.PcesReplayer;
import com.swirlds.platform.event.stream.ConsensusEventStream;
import com.swirlds.platform.event.validation.EventSignatureValidator;
import com.swirlds.platform.event.validation.InternalEventValidator;
import com.swirlds.platform.eventhandling.StateWithHashComplexity;
import com.swirlds.platform.eventhandling.TransactionHandler;
import com.swirlds.platform.eventhandling.TransactionHandlerResult;
import com.swirlds.platform.eventhandling.TransactionPrehandler;
import com.swirlds.platform.state.hasher.StateHasher;
import com.swirlds.platform.state.hashlogger.HashLogger;
import com.swirlds.platform.state.iss.IssDetector;
import com.swirlds.platform.state.iss.IssHandler;
import com.swirlds.platform.state.nexus.LatestCompleteStateNexus;
import com.swirlds.platform.state.nexus.SignedStateNexus;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.signed.SignedStateSentinel;
import com.swirlds.platform.state.signed.StateGarbageCollector;
import com.swirlds.platform.state.signed.StateSignatureCollector;
import com.swirlds.platform.state.signer.StateSigner;
import com.swirlds.platform.state.snapshot.StateSnapshotManager;
import com.swirlds.platform.system.PlatformMonitor;
import com.swirlds.platform.wiring.PlatformSchedulersConfig;
import com.swirlds.platform.wiring.components.ConsensusWiring;
import com.swirlds.platform.wiring.components.GossipWiring;
import com.swirlds.platform.wiring.components.PcesReplayerWiring;
import com.swirlds.platform.wiring.components.RunningEventHashOverrideWiring;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import org.hiero.consensus.crypto.EventHasher;
import org.hiero.consensus.event.creator.EventCreatorModule;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.ConsensusRound;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.notification.IssNotification;
import org.hiero.consensus.model.state.StateSavingResult;
import org.hiero.consensus.model.status.PlatformStatus;
import org.hiero.consensus.model.transaction.ScopedSystemTransaction;

public record PlatformComponents(WiringModel model, ComponentWiring<StateSigner, StateSignatureTransaction> stateSignerWiring, ComponentWiring<ConsensusEventStream, Void> consensusEventStreamWiring, ComponentWiring<IssHandler, Void> issHandlerWiring, ComponentWiring<LatestCompleteStateNotifier, CompleteStateNotificationWithCleanup> latestCompleteStateNotifierWiring, ComponentWiring<SignedStateNexus, Void> latestImmutableStateNexusWiring, ComponentWiring<LatestCompleteStateNexus, Void> latestCompleteStateNexusWiring, ComponentWiring<SavedStateController, StateWithHashComplexity> savedStateControllerWiring, ComponentWiring<StateGarbageCollector, Void> stateGarbageCollectorWiring, ComponentWiring<SignedStateSentinel, Void> signedStateSentinelWiring, PcesReplayerWiring pcesReplayerWiring, GossipWiring gossipWiring, ComponentWiring<StateSnapshotManager, StateSavingResult> stateSnapshotManagerWiring, ComponentWiring<EventHasher, PlatformEvent> eventHasherWiring, ComponentWiring<InternalEventValidator, PlatformEvent> internalEventValidatorWiring, ComponentWiring<EventDeduplicator, PlatformEvent> eventDeduplicatorWiring, ComponentWiring<EventSignatureValidator, PlatformEvent> eventSignatureValidatorWiring, ComponentWiring<OrphanBuffer, List<PlatformEvent>> orphanBufferWiring, ConsensusWiring consensusEngineWiring, ComponentWiring<EventCreatorModule, PlatformEvent> eventCreationManagerWiring, ComponentWiring<InlinePcesWriter, PlatformEvent> pcesInlineWriterWiring, ComponentWiring<TransactionPrehandler, Queue<ScopedSystemTransaction<StateSignatureTransaction>>> applicationTransactionPrehandlerWiring, ComponentWiring<StateSignatureCollector, List<ReservedSignedState>> stateSignatureCollectorWiring, ComponentWiring<EventWindowManager, EventWindow> eventWindowManagerWiring, ComponentWiring<TransactionHandler, TransactionHandlerResult> transactionHandlerWiring, RunningEventHashOverrideWiring runningEventHashOverrideWiring, ComponentWiring<IssDetector, List<IssNotification>> issDetectorWiring, ComponentWiring<HashLogger, Void> hashLoggerWiring, ComponentWiring<StateHasher, ReservedSignedState> stateHasherWiring, ComponentWiring<AppNotifier, Void> notifierWiring, ComponentWiring<PlatformMonitor, PlatformStatus> platformMonitorWiring, ComponentWiring<BranchDetector, PlatformEvent> branchDetectorWiring, ComponentWiring<BranchReporter, Void> branchReporterWiring) {
    public void bind(@NonNull PlatformComponentBuilder builder, @NonNull PcesReplayer pcesReplayer, @NonNull StateSignatureCollector stateSignatureCollector, @NonNull EventWindowManager eventWindowManager, @Nullable InlinePcesWriter inlinePcesWriter, @NonNull SignedStateNexus latestImmutableStateNexus, @NonNull LatestCompleteStateNexus latestCompleteStateNexus, @NonNull SavedStateController savedStateController, @NonNull AppNotifier notifier) {
        this.eventHasherWiring.bind(builder::buildEventHasher);
        this.internalEventValidatorWiring.bind(builder::buildInternalEventValidator);
        this.eventDeduplicatorWiring.bind(builder::buildEventDeduplicator);
        this.eventSignatureValidatorWiring.bind(builder::buildEventSignatureValidator);
        this.orphanBufferWiring.bind(builder::buildOrphanBuffer);
        this.consensusEngineWiring.bind(builder::buildConsensusEngine);
        this.stateSnapshotManagerWiring.bind(builder::buildStateSnapshotManager);
        this.stateSignerWiring.bind(builder::buildStateSigner);
        this.pcesReplayerWiring.bind(pcesReplayer);
        if (inlinePcesWriter != null) {
            this.pcesInlineWriterWiring.bind((Object)inlinePcesWriter);
        } else {
            this.pcesInlineWriterWiring.bind(builder::buildInlinePcesWriter);
        }
        this.eventCreationManagerWiring.bind(builder::buildEventCreator);
        this.stateSignatureCollectorWiring.bind((Object)stateSignatureCollector);
        this.eventWindowManagerWiring.bind((Object)eventWindowManager);
        this.applicationTransactionPrehandlerWiring.bind(builder::buildTransactionPrehandler);
        this.transactionHandlerWiring.bind(builder::buildTransactionHandler);
        this.consensusEventStreamWiring.bind(builder::buildConsensusEventStream);
        this.issDetectorWiring.bind(builder::buildIssDetector);
        this.issHandlerWiring.bind(builder::buildIssHandler);
        this.hashLoggerWiring.bind(builder::buildHashLogger);
        this.latestCompleteStateNotifierWiring.bind(builder::buildLatestCompleteStateNotifier);
        this.latestImmutableStateNexusWiring.bind((Object)latestImmutableStateNexus);
        this.latestCompleteStateNexusWiring.bind((Object)latestCompleteStateNexus);
        this.savedStateControllerWiring.bind((Object)savedStateController);
        this.stateHasherWiring.bind(builder::buildStateHasher);
        this.notifierWiring.bind((Object)notifier);
        this.stateGarbageCollectorWiring.bind(builder::buildStateGarbageCollector);
        this.platformMonitorWiring.bind(builder::buildPlatformMonitor);
        this.signedStateSentinelWiring.bind(builder::buildSignedStateSentinel);
        this.gossipWiring.bind(builder.buildGossip());
        this.branchDetectorWiring.bind(builder::buildBranchDetector);
        this.branchReporterWiring.bind(builder::buildBranchReporter);
    }

    public static PlatformComponents create(@NonNull PlatformContext platformContext, @NonNull WiringModel model) {
        Objects.requireNonNull(platformContext);
        Objects.requireNonNull(model);
        PlatformSchedulersConfig config = (PlatformSchedulersConfig)platformContext.getConfiguration().getConfigData(PlatformSchedulersConfig.class);
        ComponentWiring eventHasherWiring = new ComponentWiring(model, EventHasher.class, config.eventHasher());
        ComponentWiring internalEventValidatorWiring = new ComponentWiring(model, InternalEventValidator.class, config.internalEventValidator());
        ComponentWiring eventDeduplicatorWiring = new ComponentWiring(model, EventDeduplicator.class, config.eventDeduplicator());
        ComponentWiring eventSignatureValidatorWiring = new ComponentWiring(model, EventSignatureValidator.class, config.eventSignatureValidator());
        ComponentWiring orphanBufferWiring = new ComponentWiring(model, OrphanBuffer.class, config.orphanBuffer());
        ConsensusWiring consensusEngineWiring = ConsensusWiring.create(model, config.consensusEngine());
        ComponentWiring eventCreationManagerWiring = new ComponentWiring(model, EventCreatorModule.class, config.eventCreationManager());
        ComponentWiring applicationTransactionPrehandlerWiring = new ComponentWiring(model, TransactionPrehandler.class, config.applicationTransactionPrehandler());
        ComponentWiring stateSignatureCollectorWiring = new ComponentWiring(model, StateSignatureCollector.class, config.stateSignatureCollector());
        ComponentWiring stateSnapshotManagerWiring = new ComponentWiring(model, StateSnapshotManager.class, config.stateSnapshotManager());
        ComponentWiring stateSignerWiring = new ComponentWiring(model, StateSigner.class, config.stateSigner());
        ComponentWiring transactionHandlerWiring = new ComponentWiring(model, TransactionHandler.class, config.transactionHandler(), data -> {
            int n;
            if (data instanceof ConsensusRound) {
                ConsensusRound consensusRound = (ConsensusRound)data;
                n = Math.max(consensusRound.getNumAppTransactions(), 1);
            } else {
                n = 1;
            }
            return n;
        });
        ComponentWiring consensusEventStreamWiring = new ComponentWiring(model, ConsensusEventStream.class, config.consensusEventStream());
        RunningEventHashOverrideWiring runningEventHashOverrideWiring = RunningEventHashOverrideWiring.create(model);
        ComponentWiring stateHasherWiring = new ComponentWiring(model, StateHasher.class, config.stateHasher(), data -> {
            long l;
            if (data instanceof StateWithHashComplexity) {
                StateWithHashComplexity swhc = (StateWithHashComplexity)data;
                l = swhc.hashComplexity();
            } else {
                l = 1L;
            }
            return l;
        });
        GossipWiring gossipWiring = new GossipWiring(platformContext, model);
        PcesReplayerWiring pcesReplayerWiring = PcesReplayerWiring.create(model);
        ComponentWiring pcesInlineWriterWiring = new ComponentWiring(model, InlinePcesWriter.class, config.pcesInlineWriter());
        ComponentWiring eventWindowManagerWiring = new ComponentWiring(model, EventWindowManager.class, TaskSchedulerConfiguration.DIRECT_THREADSAFE_CONFIGURATION);
        ComponentWiring issDetectorWiring = new ComponentWiring(model, IssDetector.class, config.issDetector());
        ComponentWiring issHandlerWiring = new ComponentWiring(model, IssHandler.class, config.issHandler());
        ComponentWiring hashLoggerWiring = new ComponentWiring(model, HashLogger.class, config.hashLogger());
        ComponentWiring latestCompleteStateNotifierWiring = new ComponentWiring(model, LatestCompleteStateNotifier.class, config.latestCompleteStateNotifier());
        ComponentWiring latestImmutableStateNexusWiring = new ComponentWiring(model, SignedStateNexus.class, TaskSchedulerConfiguration.DIRECT_THREADSAFE_CONFIGURATION);
        ComponentWiring latestCompleteStateNexusWiring = new ComponentWiring(model, LatestCompleteStateNexus.class, TaskSchedulerConfiguration.DIRECT_THREADSAFE_CONFIGURATION);
        ComponentWiring savedStateControllerWiring = new ComponentWiring(model, SavedStateController.class, TaskSchedulerConfiguration.DIRECT_THREADSAFE_CONFIGURATION);
        ComponentWiring notifierWiring = new ComponentWiring(model, AppNotifier.class, TaskSchedulerConfiguration.DIRECT_THREADSAFE_CONFIGURATION);
        ComponentWiring stateGarbageCollectorWiring = new ComponentWiring(model, StateGarbageCollector.class, config.stateGarbageCollector());
        ComponentWiring signedStateSentinelWiring = new ComponentWiring(model, SignedStateSentinel.class, config.signedStateSentinel());
        ComponentWiring platformMonitorWiring = new ComponentWiring(model, PlatformMonitor.class, config.platformMonitor());
        ComponentWiring branchDetectorWiring = new ComponentWiring(model, BranchDetector.class, config.branchDetector());
        ComponentWiring branchReporterWiring = new ComponentWiring(model, BranchReporter.class, config.branchReporter());
        return new PlatformComponents(model, (ComponentWiring<StateSigner, StateSignatureTransaction>)stateSignerWiring, (ComponentWiring<ConsensusEventStream, Void>)consensusEventStreamWiring, (ComponentWiring<IssHandler, Void>)issHandlerWiring, (ComponentWiring<LatestCompleteStateNotifier, CompleteStateNotificationWithCleanup>)latestCompleteStateNotifierWiring, (ComponentWiring<SignedStateNexus, Void>)latestImmutableStateNexusWiring, (ComponentWiring<LatestCompleteStateNexus, Void>)latestCompleteStateNexusWiring, (ComponentWiring<SavedStateController, StateWithHashComplexity>)savedStateControllerWiring, (ComponentWiring<StateGarbageCollector, Void>)stateGarbageCollectorWiring, (ComponentWiring<SignedStateSentinel, Void>)signedStateSentinelWiring, pcesReplayerWiring, gossipWiring, (ComponentWiring<StateSnapshotManager, StateSavingResult>)stateSnapshotManagerWiring, (ComponentWiring<EventHasher, PlatformEvent>)eventHasherWiring, (ComponentWiring<InternalEventValidator, PlatformEvent>)internalEventValidatorWiring, (ComponentWiring<EventDeduplicator, PlatformEvent>)eventDeduplicatorWiring, (ComponentWiring<EventSignatureValidator, PlatformEvent>)eventSignatureValidatorWiring, (ComponentWiring<OrphanBuffer, List<PlatformEvent>>)orphanBufferWiring, consensusEngineWiring, (ComponentWiring<EventCreatorModule, PlatformEvent>)eventCreationManagerWiring, (ComponentWiring<InlinePcesWriter, PlatformEvent>)pcesInlineWriterWiring, (ComponentWiring<TransactionPrehandler, Queue<ScopedSystemTransaction<StateSignatureTransaction>>>)applicationTransactionPrehandlerWiring, (ComponentWiring<StateSignatureCollector, List<ReservedSignedState>>)stateSignatureCollectorWiring, (ComponentWiring<EventWindowManager, EventWindow>)eventWindowManagerWiring, (ComponentWiring<TransactionHandler, TransactionHandlerResult>)transactionHandlerWiring, runningEventHashOverrideWiring, (ComponentWiring<IssDetector, List<IssNotification>>)issDetectorWiring, (ComponentWiring<HashLogger, Void>)hashLoggerWiring, (ComponentWiring<StateHasher, ReservedSignedState>)stateHasherWiring, (ComponentWiring<AppNotifier, Void>)notifierWiring, (ComponentWiring<PlatformMonitor, PlatformStatus>)platformMonitorWiring, (ComponentWiring<BranchDetector, PlatformEvent>)branchDetectorWiring, (ComponentWiring<BranchReporter, Void>)branchReporterWiring);
    }
}

