/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.formatting;

import com.swirlds.common.formatting.HorizontalAlignment;
import com.swirlds.common.formatting.StringFormattingUtils;
import com.swirlds.common.formatting.TextEffect;
import com.swirlds.common.formatting.TextTable;
import com.swirlds.common.formatting.UnitFormatter;
import com.swirlds.common.units.DataUnit;
import com.swirlds.common.units.Unit;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class TextHistogram<T> {
    private static final int DEFAULT_HISTOGRAM_WIDTH = 32;
    private static final String HISTOGRAM_CHARACTER = "*";
    private boolean colorEnabled = true;
    private boolean showValues = true;
    private int width = 32;
    private Function<T, Object> timestampExtractor;
    private final Function<T, Long> valueExtractor;
    private Unit<?> valueUnit;
    private final List<T> data;

    public TextHistogram(@NonNull List<T> data, @NonNull Function<T, Long> valueExtractor) {
        Objects.requireNonNull(data, "data must not be null");
        Objects.requireNonNull(valueExtractor, "valueExtractor must not be null");
        this.data = data;
        this.valueExtractor = valueExtractor;
    }

    public TextHistogram<T> setColorEnabled(boolean colorEnabled) {
        this.colorEnabled = colorEnabled;
        return this;
    }

    public TextHistogram<T> setShowValues(boolean showValues) {
        this.showValues = showValues;
        return this;
    }

    public TextHistogram<T> setValueUnit(Unit<?> valueUnit) {
        this.valueUnit = valueUnit;
        return this;
    }

    public TextHistogram<T> setWidth(int width) {
        this.width = width;
        return this;
    }

    public TextHistogram<T> setTimestampExtractor(Function<T, Object> timestampExtractor) {
        this.timestampExtractor = timestampExtractor;
        return this;
    }

    public String render() {
        StringBuilder sb = new StringBuilder();
        this.render(sb);
        return sb.toString();
    }

    public void render(StringBuilder sb) {
        long max = 0L;
        for (T datum : this.data) {
            max = Math.max(max, this.valueExtractor.apply(datum));
        }
        TextTable table = new TextTable().setBordersEnabled(false).setColumnHorizontalAlignment(1, HorizontalAlignment.ALIGNED_RIGHT);
        UnitFormatter valueFormatter = this.valueUnit != null ? new UnitFormatter(DataUnit.UNIT_BYTES).setAbbreviate(true).setDecimalPlaces(1) : null;
        for (T datum : this.data) {
            ArrayList<String> row = new ArrayList<String>();
            if (this.timestampExtractor != null) {
                String timestamp = this.timestampExtractor.apply(datum).toString();
                if (this.colorEnabled) {
                    row.add(TextEffect.GRAY.apply(timestamp));
                } else {
                    row.add(timestamp);
                }
            }
            if (this.showValues) {
                String value;
                if (valueFormatter != null) {
                    valueFormatter.setQuantity(this.valueExtractor.apply(datum));
                    value = valueFormatter.render();
                } else {
                    value = StringFormattingUtils.commaSeparatedNumber(this.valueExtractor.apply(datum));
                }
                if (this.colorEnabled) {
                    row.add(TextEffect.BRIGHT_RED.apply(value));
                } else {
                    row.add(value);
                }
            }
            long value = this.valueExtractor.apply(datum);
            int barLength = max == 0L ? 0 : (int)((double)value / (double)max * (double)this.width);
            String bar = HISTOGRAM_CHARACTER.repeat(barLength);
            if (this.colorEnabled) {
                row.add(TextEffect.BRIGHT_YELLOW.apply(bar));
            } else {
                row.add(bar);
            }
            table.addRow(row.toArray());
        }
        table.render(sb);
    }
}

