/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.formatting;

import com.swirlds.common.formatting.StringFormattingUtils;
import com.swirlds.common.formatting.UnitFormat;
import com.swirlds.common.units.Unit;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class UnitFormatter {
    private boolean abbreviate = true;
    private int decimalPlaces = 1;
    private boolean showUnit = true;
    private boolean showSpaceInBetween = true;
    private UnitFormat unitFormat = UnitFormat.SINGLE_SIMPLIFIED;
    private Long longQuantity;
    private Double doubleQuantity;
    private final Unit<?> unit;
    private Unit<?> lowestUnit;
    private int unitCount;

    public UnitFormatter(long quantity, Unit<?> unit) {
        this.setQuantity(quantity);
        this.unit = unit;
    }

    public UnitFormatter(double quantity, Unit<?> unit) {
        this.setQuantity(quantity);
        this.unit = unit;
    }

    public UnitFormatter(Unit<?> unit) {
        this.setQuantity(0L);
        this.unit = unit;
    }

    @NonNull
    public UnitFormatter setUnitFormat(@NonNull UnitFormat unitFormat) {
        this.unitFormat = unitFormat;
        return this;
    }

    @NonNull
    public UnitFormatter setQuantity(long quantity) {
        this.doubleQuantity = null;
        this.longQuantity = quantity;
        return this;
    }

    @NonNull
    public UnitFormatter setQuantity(double quantity) {
        this.longQuantity = null;
        this.doubleQuantity = quantity;
        return this;
    }

    @NonNull
    public UnitFormatter setAbbreviate(boolean abbreviate) {
        this.abbreviate = abbreviate;
        return this;
    }

    @NonNull
    public UnitFormatter setDecimalPlaces(int decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
        return this;
    }

    @NonNull
    public UnitFormatter setShowUnit(boolean showUnit) {
        this.showUnit = showUnit;
        return this;
    }

    @NonNull
    public UnitFormatter setLowestUnit(@NonNull Unit<?> lowestUnit) {
        if (this.unitCount != 0) {
            throw new IllegalArgumentException("unitCount is already set");
        }
        this.lowestUnit = Objects.requireNonNull(lowestUnit);
        return this;
    }

    @NonNull
    public UnitFormatter setUnitCount(int unitCount) {
        if (this.lowestUnit != null) {
            throw new IllegalArgumentException("lowestUnit is already set");
        }
        this.unitCount = unitCount;
        return this;
    }

    @NonNull
    public UnitFormatter setShowSpaceInBetween(boolean showSpaceInBetween) {
        this.showSpaceInBetween = showSpaceInBetween;
        return this;
    }

    @NonNull
    public String render() {
        StringBuilder sb = new StringBuilder();
        this.render(sb);
        return sb.toString();
    }

    private boolean isQuantityPlural(@NonNull String quantityString) {
        return Double.parseDouble(quantityString.replace(",", "")) != 1.0;
    }

    private void appendUnit(@NonNull StringBuilder stringBuilder, @NonNull String quantityString, @NonNull Unit<?> finalUnit) {
        if (this.showSpaceInBetween) {
            stringBuilder.append(" ");
        }
        if (this.abbreviate) {
            stringBuilder.append(finalUnit.getAbbreviation());
        } else if (this.isQuantityPlural(quantityString)) {
            stringBuilder.append(finalUnit.getPluralName());
        } else {
            stringBuilder.append(finalUnit.getName());
        }
    }

    private void formatWithUnsimplifiedUnit(@NonNull StringBuilder stringBuilder) {
        double quantity = this.longQuantity == null ? this.doubleQuantity : (double)this.longQuantity.longValue();
        String quantityString = StringFormattingUtils.commaSeparatedNumber(quantity, this.decimalPlaces);
        stringBuilder.append(quantityString);
        if (this.showUnit) {
            this.appendUnit(stringBuilder, quantityString, this.unit);
        }
    }

    private void formatWithSingleSimplifiedUnit(@NonNull StringBuilder stringBuilder) {
        Unit.SimplifiedQuantity<?> simplifiedQuantity = this.longQuantity == null ? this.unit.simplify(this.doubleQuantity) : this.unit.simplify(this.longQuantity.longValue());
        String quantityString = StringFormattingUtils.commaSeparatedNumber(simplifiedQuantity.quantity(), this.decimalPlaces);
        stringBuilder.append(quantityString);
        if (this.showUnit) {
            this.appendUnit(stringBuilder, quantityString, simplifiedQuantity.unit());
        }
    }

    @NonNull
    private Unit.SimplifiedQuantity<?> addTerm(@NonNull StringBuilder stringBuilder, @NonNull Unit.SimplifiedQuantity<?> startingQuantity, int finalUnitOrdinal) {
        long roundedDownQuantity = (long)startingQuantity.quantity();
        Unit.SimplifiedQuantity remainder = new Unit.SimplifiedQuantity(startingQuantity.quantity() - (double)roundedDownQuantity, startingQuantity.unit());
        Unit.SimplifiedQuantity<?> simplifiedRemainder = remainder.unit().simplify(remainder.quantity());
        String termString = simplifiedRemainder.unit().ordinal() < finalUnitOrdinal ? StringFormattingUtils.commaSeparatedNumber(startingQuantity.quantity(), this.decimalPlaces) : StringFormattingUtils.commaSeparatedNumber(roundedDownQuantity, 0);
        stringBuilder.append(termString);
        this.appendUnit(stringBuilder, termString, startingQuantity.unit());
        return simplifiedRemainder;
    }

    private void formatWithMultiSimplifiedUnits(@NonNull StringBuilder stringBuilder) {
        double originalQuantity = this.longQuantity == null ? this.doubleQuantity : (double)this.longQuantity.longValue();
        Unit.SimplifiedQuantity<?> firstTerm = new Unit.SimplifiedQuantity(originalQuantity, this.unit).unit().simplify(originalQuantity);
        int finalUnitOrdinal = this.lowestUnit != null ? this.lowestUnit.ordinal() : (this.unitCount != 0 ? Math.max(0, firstTerm.unit().ordinal() - this.unitCount + 1) : this.unit.ordinal());
        Unit.SimplifiedQuantity<?> remainder = this.addTerm(stringBuilder, firstTerm, finalUnitOrdinal);
        while (remainder.unit().ordinal() >= finalUnitOrdinal) {
            stringBuilder.append(" ");
            remainder = this.addTerm(stringBuilder, remainder, finalUnitOrdinal);
        }
    }

    public void render(@NonNull StringBuilder stringBuilder) {
        Objects.requireNonNull(stringBuilder);
        if (this.longQuantity == null && this.doubleQuantity == null) {
            throw new IllegalStateException("Quantity must be set");
        }
        if (this.longQuantity != null && this.doubleQuantity != null) {
            throw new IllegalStateException("Quantity must be set to either long or double, not both");
        }
        switch (this.unitFormat) {
            case UNSIMPLIFIED: {
                this.formatWithUnsimplifiedUnit(stringBuilder);
                break;
            }
            case SINGLE_SIMPLIFIED: {
                this.formatWithSingleSimplifiedUnit(stringBuilder);
                break;
            }
            case MULTI_SIMPLIFIED: {
                this.formatWithMultiSimplifiedUnits(stringBuilder);
            }
        }
    }
}

