/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.framework.internal;

import com.swirlds.common.threading.framework.Stoppable;
import com.swirlds.common.threading.framework.ThreadSeed;
import com.swirlds.common.threading.framework.TypedStoppableThread;
import com.swirlds.common.threading.framework.internal.AbstractThreadConfiguration;
import com.swirlds.common.threading.framework.internal.StoppableThreadImpl;
import com.swirlds.common.threading.manager.ThreadManager;
import java.time.Duration;
import org.hiero.base.concurrent.interrupt.InterruptableRunnable;

public abstract class AbstractStoppableThreadConfiguration<C extends AbstractStoppableThreadConfiguration<C, T>, T extends InterruptableRunnable>
extends AbstractThreadConfiguration<C> {
    public static final Stoppable.StopBehavior DEFAULT_STOP_BEHAVIOR = Stoppable.StopBehavior.INTERRUPTABLE;
    public static final int DEFAULT_JOIN_WAIT_MS = 50;
    public static final Duration DEFAULT_HANGING_PERIOD = Duration.ofMinutes(1L);
    public static final Duration DEFAULT_LOG_AFTER_PAUSE_DURATION = Duration.ZERO;
    private Stoppable.StopBehavior stopBehavior = DEFAULT_STOP_BEHAVIOR;
    private int joinWaitMs = 50;
    private Duration logAfterPauseDuration = DEFAULT_LOG_AFTER_PAUSE_DURATION;
    private Duration minimumPeriod;
    private T work;
    private InterruptableRunnable finalCycleWork;
    private Duration hangingThreadPeriod = DEFAULT_HANGING_PERIOD;

    protected AbstractStoppableThreadConfiguration(ThreadManager threadManager) {
        super(threadManager);
    }

    protected AbstractStoppableThreadConfiguration(AbstractStoppableThreadConfiguration<C, T> that) {
        super(that);
        this.stopBehavior = that.stopBehavior;
        this.joinWaitMs = that.joinWaitMs;
        this.work = that.work;
        this.finalCycleWork = that.finalCycleWork;
        this.hangingThreadPeriod = that.hangingThreadPeriod;
        this.minimumPeriod = that.minimumPeriod;
    }

    @Override
    public abstract AbstractStoppableThreadConfiguration<C, T> copy();

    protected TypedStoppableThread<T> buildStoppableThread(boolean start) {
        StoppableThreadImpl thread = new StoppableThreadImpl(this);
        if (start) {
            thread.start();
        }
        return thread;
    }

    protected ThreadSeed buildStoppableThreadSeed(StoppableThreadImpl<T> stoppableThread) {
        stoppableThread.setInjected();
        return () -> {
            stoppableThread.markAsStarted(Thread.currentThread());
            this.buildThreadSeed().inject();
        };
    }

    protected InterruptableRunnable getFinalCycleWork() {
        return this.finalCycleWork;
    }

    protected C setFinalCycleWork(InterruptableRunnable finalCycleWork) {
        this.throwIfImmutable();
        this.finalCycleWork = finalCycleWork;
        return (C)this;
    }

    protected T getWork() {
        return this.work;
    }

    protected C setWork(T work) {
        this.throwIfImmutable();
        this.work = work;
        return (C)this;
    }

    public Stoppable.StopBehavior getStopBehavior() {
        return this.stopBehavior;
    }

    public C setStopBehavior(Stoppable.StopBehavior stopBehavior) {
        this.throwIfImmutable();
        this.stopBehavior = stopBehavior;
        return (C)this;
    }

    public Duration getMinimumPeriod() {
        return this.minimumPeriod;
    }

    public C setMinimumPeriod(Duration minimumPeriod) {
        this.throwIfImmutable();
        this.minimumPeriod = minimumPeriod;
        return (C)this;
    }

    public double getMaximumRate() {
        if (this.minimumPeriod == null) {
            return -1.0;
        }
        return 1.0 / ((double)this.minimumPeriod.toNanos() * 1.0E-9);
    }

    public C setMaximumRate(double hz) {
        this.throwIfImmutable();
        if (hz <= 0.0) {
            throw new IllegalArgumentException("invalid hertz value " + hz);
        }
        this.minimumPeriod = Duration.ofNanos((long)(1.0 / hz * 1.0E9));
        return (C)this;
    }

    public int getJoinWaitMs() {
        return this.joinWaitMs;
    }

    public C setJoinWaitMs(int joinWaitMs) {
        this.throwIfImmutable();
        this.joinWaitMs = joinWaitMs;
        return (C)this;
    }

    public Duration getHangingThreadPeriod() {
        return this.hangingThreadPeriod;
    }

    public C setHangingThreadPeriod(Duration hangingThreadPeriod) {
        this.throwIfImmutable();
        this.hangingThreadPeriod = hangingThreadPeriod;
        return (C)this;
    }

    public Duration getLogAfterPauseDuration() {
        return this.logAfterPauseDuration;
    }

    public C setLogAfterPauseDuration(Duration logAfterPauseDuration) {
        this.logAfterPauseDuration = logAfterPauseDuration;
        return (C)this;
    }
}

