/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.units.internal;

import com.swirlds.common.units.Unit;

public class UnitConverter<T extends Unit<T>> {
    private final T[] types;
    private final long[] factors;

    public UnitConverter(T ... units) {
        this.factors = new long[units.length * units.length];
        this.types = new Unit[units.length];
        for (T from : units) {
            this.types[from.ordinal()] = from;
            for (T to : units) {
                int i;
                int index = this.getConversionFactorIndex((Unit<T>)from, (Unit<T>)to);
                this.factors[index] = 1L;
                if (from.ordinal() > to.ordinal()) {
                    for (i = from.ordinal(); i > to.ordinal(); --i) {
                        int n = index;
                        this.factors[n] = this.factors[n] * (long)units[i].getConversionFactor();
                    }
                    continue;
                }
                for (i = to.ordinal(); i > from.ordinal(); --i) {
                    int n = index;
                    this.factors[n] = this.factors[n] * (long)units[i].getConversionFactor();
                }
            }
        }
    }

    private int getConversionFactorIndex(Unit<T> to, Unit<T> from) {
        return to.ordinal() * this.types.length + from.ordinal();
    }

    public Unit.SimplifiedQuantity<T> simplify(double quantity, T unit) {
        double currentQuantity = quantity;
        int currentIndex = unit.ordinal();
        while (currentIndex > 0 && Math.abs(currentQuantity) < 1.0) {
            currentQuantity = this.convertTo(quantity, unit, this.types[--currentIndex]);
        }
        while (currentIndex < this.types.length - 1 && Math.abs(currentQuantity) >= (double)this.types[currentIndex + 1].getConversionFactor()) {
            currentQuantity = this.convertTo(quantity, unit, this.types[++currentIndex]);
        }
        return new Unit.SimplifiedQuantity(currentQuantity, this.types[currentIndex]);
    }

    public double convertTo(double quantity, T from, T to) {
        if (from == to) {
            return quantity;
        }
        long factor = this.factors[this.getConversionFactorIndex((Unit<T>)from, (Unit<T>)to)];
        if (from.ordinal() > to.ordinal()) {
            return quantity * (double)factor;
        }
        return quantity / (double)factor;
    }

    public double convertTo(long quantity, T from, T to) {
        if (from == to) {
            return quantity;
        }
        long factor = this.factors[this.getConversionFactorIndex((Unit<T>)from, (Unit<T>)to)];
        if (from.ordinal() > to.ordinal()) {
            return quantity * factor;
        }
        return (double)quantity / (double)factor;
    }

    public record UnitConversion<T>(T type, long factor) {
    }
}

