/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.files.hashmap;

import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkledb.FileStatisticAware;
import com.swirlds.merkledb.Snapshotable;
import com.swirlds.merkledb.collections.CASableLongIndex;
import com.swirlds.merkledb.collections.LongList;
import com.swirlds.merkledb.collections.LongListDisk;
import com.swirlds.merkledb.collections.LongListOffHeap;
import com.swirlds.merkledb.collections.OffHeapUser;
import com.swirlds.merkledb.config.MerkleDbConfig;
import com.swirlds.merkledb.files.DataFileCollection;
import com.swirlds.merkledb.files.DataFileCommon;
import com.swirlds.merkledb.files.DataFileReader;
import com.swirlds.merkledb.files.MemoryIndexDiskKeyValueStore;
import com.swirlds.merkledb.files.hashmap.Bucket;
import com.swirlds.merkledb.files.hashmap.BucketMutation;
import com.swirlds.merkledb.files.hashmap.ParsedBucket;
import com.swirlds.merkledb.files.hashmap.ReusableBucketPool;
import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.LongSummaryStatistics;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.tuple.primitive.IntObjectPair;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.hiero.base.concurrent.AbstractTask;

public class HalfDiskHashMap
implements AutoCloseable,
Snapshotable,
FileStatisticAware,
OffHeapUser {
    private static final Logger logger = LogManager.getLogger(HalfDiskHashMap.class);
    private static final int METADATA_FILE_FORMAT_VERSION = 1;
    private static final String METADATA_FILENAME_SUFFIX = "_metadata.hdhm";
    private static final String BUCKET_INDEX_FILENAME_SUFFIX = "_bucket_index.ll";
    protected static final long INVALID_VALUE = Long.MIN_VALUE;
    private final int goodAverageBucketEntryCount;
    private static final int MAX_IN_FLIGHT = 1024;
    @NonNull
    private final Configuration config;
    private final LongList bucketIndexToBucketLocation;
    private final DataFileCollection fileCollection;
    private final AtomicInteger numOfBuckets = new AtomicInteger();
    private final AtomicInteger bucketMaskBits = new AtomicInteger(0);
    private final String storeName;
    private final ReusableBucketPool bucketPool;
    private IntObjectHashMap<BucketMutation> oneTransactionsData = null;
    private Thread writingThread;
    private final AtomicReference<SubmitTask> currentSubmitTask = new AtomicReference();
    private final AtomicInteger updatedBucketsCount = new AtomicInteger();
    private final AtomicInteger bucketPermits = new AtomicInteger(1024);
    private final AtomicReference<StoreBucketTask> lastStoreTask = new AtomicReference();
    private final AtomicInteger storeBucketTasksCreated = new AtomicInteger();
    private final AtomicReference<AbstractTask> notifyTaskRef = new AtomicReference();
    private final AtomicReference<Throwable> exceptionOccurred = new AtomicReference();
    private static volatile ForkJoinPool flushingPool = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ForkJoinPool getFlushingPool(@NonNull Configuration config) {
        Objects.requireNonNull(config);
        ForkJoinPool pool = flushingPool;
        if (pool != null) return pool;
        Class<HalfDiskHashMap> clazz = HalfDiskHashMap.class;
        synchronized (HalfDiskHashMap.class) {
            pool = flushingPool;
            if (pool != null) return pool;
            MerkleDbConfig merkleDbConfig = (MerkleDbConfig)config.getConfigData(MerkleDbConfig.class);
            int hashingThreadCount = merkleDbConfig.getNumHalfDiskHashMapFlushThreads();
            flushingPool = pool = new ForkJoinPool(hashingThreadCount);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return pool;
        }
    }

    public HalfDiskHashMap(@NonNull Configuration configuration, long initialCapacity, Path storeDir, String storeName, String legacyStoreName, boolean preferDiskBasedIndex) throws IOException {
        DataFileCollection.LoadedDataCallback loadedDataCallback;
        this.config = Objects.requireNonNull(configuration);
        MerkleDbConfig merkleDbConfig = (MerkleDbConfig)this.config.getConfigData(MerkleDbConfig.class);
        this.goodAverageBucketEntryCount = merkleDbConfig.goodAverageBucketEntryCount();
        long bucketIndexCapacity = merkleDbConfig.maxNumOfKeys() * 2L / (long)this.goodAverageBucketEntryCount;
        this.storeName = storeName;
        Path indexFile = storeDir.resolve(storeName + BUCKET_INDEX_FILENAME_SUFFIX);
        this.bucketPool = new ReusableBucketPool(Bucket::new);
        if (Files.exists(storeDir, new LinkOption[0])) {
            Path metaDataFile = storeDir.resolve(storeName + METADATA_FILENAME_SUFFIX);
            boolean loadedLegacyMetadata = false;
            if (!Files.exists(metaDataFile, new LinkOption[0])) {
                metaDataFile = storeDir.resolve(legacyStoreName + METADATA_FILENAME_SUFFIX);
                indexFile = storeDir.resolve(legacyStoreName + BUCKET_INDEX_FILENAME_SUFFIX);
                loadedLegacyMetadata = true;
            }
            if (Files.exists(metaDataFile, new LinkOption[0])) {
                try (DataInputStream metaIn = new DataInputStream(Files.newInputStream(metaDataFile, new OpenOption[0]));){
                    int fileVersion = metaIn.readInt();
                    if (fileVersion != 1) {
                        throw new IOException("Tried to read a file with incompatible file format version [" + fileVersion + "], expected [1].");
                    }
                    metaIn.readInt();
                    this.setNumberOfBuckets(metaIn.readInt());
                }
                if (loadedLegacyMetadata) {
                    Files.delete(metaDataFile);
                }
            } else {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Loading existing set of data files but no metadata file was found in [{}]", (Object)storeDir.toAbsolutePath());
                throw new IOException("Can not load an existing HalfDiskHashMap from [" + String.valueOf(storeDir.toAbsolutePath()) + "] because metadata file is missing");
            }
            boolean forceIndexRebuilding = merkleDbConfig.indexRebuildingEnforced();
            if (Files.exists(indexFile, new LinkOption[0]) && !forceIndexRebuilding) {
                this.bucketIndexToBucketLocation = preferDiskBasedIndex ? new LongListDisk(indexFile, bucketIndexCapacity, configuration) : new LongListOffHeap(indexFile, bucketIndexCapacity, configuration);
                loadedDataCallback = null;
            } else {
                this.bucketIndexToBucketLocation = preferDiskBasedIndex ? new LongListDisk(bucketIndexCapacity, configuration) : new LongListOffHeap(bucketIndexCapacity, configuration);
                loadedDataCallback = (dataLocation, bucketData) -> {
                    Bucket bucket = this.bucketPool.getBucket();
                    bucket.readFrom((ReadableSequentialData)bucketData);
                    this.bucketIndexToBucketLocation.put(bucket.getBucketIndex(), dataLocation);
                };
            }
        } else {
            Files.createDirectories(storeDir, new FileAttribute[0]);
            int minimumBuckets = (int)(initialCapacity / (long)this.goodAverageBucketEntryCount);
            this.setNumberOfBuckets(Math.max(Integer.highestOneBit(minimumBuckets) * 2, 2));
            this.bucketIndexToBucketLocation = preferDiskBasedIndex ? new LongListDisk(bucketIndexCapacity, configuration) : new LongListOffHeap(bucketIndexCapacity, configuration);
            loadedDataCallback = null;
            this.writeMetadata(storeDir);
            logger.info(LogMarker.MERKLE_DB.getMarker(), "HalfDiskHashMap [{}] created with minimumBuckets={} and numOfBuckets={}", (Object)storeName, (Object)minimumBuckets, (Object)this.numOfBuckets);
        }
        this.bucketIndexToBucketLocation.updateValidRange(0L, this.numOfBuckets.get() - 1);
        this.fileCollection = new DataFileCollection(merkleDbConfig, storeDir, storeName, legacyStoreName, loadedDataCallback);
        this.fileCollection.updateValidKeyRange(0L, this.numOfBuckets.get() - 1);
    }

    private void writeMetadata(Path dir) throws IOException {
        try (DataOutputStream metaOut = new DataOutputStream(Files.newOutputStream(dir.resolve(this.storeName + METADATA_FILENAME_SUFFIX), new OpenOption[0]));){
            metaOut.writeInt(1);
            metaOut.writeInt(0);
            metaOut.writeInt(this.numOfBuckets.get());
            metaOut.flush();
        }
    }

    public void repair(long firstLeafPath, long lastLeafPath, MemoryIndexDiskKeyValueStore store) throws IOException {
        logger.info(LogMarker.MERKLE_DB.getMarker(), "Rebuilding HDHM {}, leaf path range [{},{}]", (Object)this.storeName, (Object)firstLeafPath, (Object)lastLeafPath);
        AtomicBoolean newDataFile = new AtomicBoolean(false);
        AtomicLong liveEntries = new AtomicLong(0L);
        int bucketCount = this.numOfBuckets.get();
        int bucketMask = (1 << this.bucketMaskBits.get()) - 1;
        LongList bucketIndex = this.bucketIndexToBucketLocation;
        for (int i = 0; i < bucketCount; ++i) {
            long bucketId = i;
            long bucketDataLocation = bucketIndex.get(bucketId);
            if (bucketDataLocation <= 0L) continue;
            BufferedData bucketData = this.fileCollection.readDataItemUsingIndex(bucketIndex, bucketId);
            if (bucketData == null) {
                logger.warn("Delete bucket (not found): {}, dataLocation={}", (Object)bucketId, (Object)bucketDataLocation);
                bucketIndex.remove(bucketId);
                continue;
            }
            try (ParsedBucket bucket = new ParsedBucket();){
                bucket.readFrom((ReadableSequentialData)bucketData);
                long loadedBucketId = bucket.getBucketIndex();
                if ((loadedBucketId & bucketId) != loadedBucketId) {
                    logger.warn(LogMarker.MERKLE_DB.getMarker(), "Delete bucket (stale): {}", (Object)bucketId);
                    bucketIndex.remove(bucketId);
                    continue;
                }
                bucket.forEachEntry(entry -> {
                    Bytes keyBytes = entry.getKeyBytes();
                    long path = entry.getValue();
                    int hashCode = entry.getHashCode();
                    try {
                        boolean removeKey = true;
                        if (path < firstLeafPath || path > lastLeafPath) {
                            logger.warn(LogMarker.MERKLE_DB.getMarker(), "Delete key (path range): key={}, path={}", (Object)keyBytes, (Object)path);
                        } else if (((long)hashCode & loadedBucketId) != loadedBucketId) {
                            logger.warn(LogMarker.MERKLE_DB.getMarker(), "Delete key (hash code): key={}, path={}", (Object)keyBytes, (Object)path);
                        } else {
                            BufferedData recordBytes = store.get(path);
                            if (recordBytes == null) {
                                throw new IOException("Record not found in pathToKeyValue store, path=" + path);
                            }
                            VirtualLeafBytes record = VirtualLeafBytes.parseFrom((ReadableSequentialData)recordBytes);
                            if (!record.keyBytes().equals((Object)keyBytes)) {
                                logger.warn(LogMarker.MERKLE_DB.getMarker(), "Delete key (stale): path={}, expected={}, actual={}", (Object)path, (Object)record.keyBytes(), (Object)keyBytes);
                            } else {
                                removeKey = false;
                            }
                        }
                        if (removeKey) {
                            if (newDataFile.compareAndSet(false, true)) {
                                this.startWriting();
                            }
                            this.delete(keyBytes);
                        } else if ((long)(hashCode & bucketMask) == bucketId) {
                            liveEntries.incrementAndGet();
                        }
                    }
                    catch (Exception e) {
                        logger.error(LogMarker.MERKLE_DB.getMarker(), "Exception while processing bucket entry, bucket={}, key={} path={}", (Object)bucketId, (Object)keyBytes, (Object)path, (Object)e);
                    }
                });
                continue;
            }
        }
        if (newDataFile.get()) {
            this.endWriting();
        }
        long expectedEntries = lastLeafPath - firstLeafPath + 1L;
        if (liveEntries.get() != expectedEntries) {
            throw new IOException("HDHM repair failed, expected keys = " + expectedEntries + ", actual = " + liveEntries.get());
        }
    }

    @Override
    public void snapshot(Path snapshotDirectory) throws IOException {
        Files.createDirectories(snapshotDirectory, new FileAttribute[0]);
        this.bucketIndexToBucketLocation.writeToFile(snapshotDirectory.resolve(this.storeName + BUCKET_INDEX_FILENAME_SUFFIX));
        this.fileCollection.snapshot(snapshotDirectory);
        this.writeMetadata(snapshotDirectory);
    }

    @Override
    public long getOffHeapConsumption() {
        LongList longList = this.bucketIndexToBucketLocation;
        if (longList instanceof LongListOffHeap) {
            LongListOffHeap offheapIndex = (LongListOffHeap)longList;
            return offheapIndex.getOffHeapConsumption();
        }
        return 0L;
    }

    @Override
    public LongSummaryStatistics getFilesSizeStatistics() {
        return this.fileCollection.getFilesSizeStatistics();
    }

    @Override
    public void close() throws IOException {
        this.fileCollection.close();
        this.bucketIndexToBucketLocation.close();
    }

    public void startWriting() {
        this.oneTransactionsData = new IntObjectHashMap();
        this.writingThread = Thread.currentThread();
    }

    private BucketMutation findBucketForUpdate(Bytes keyBytes, int keyHashCode, long oldValue, long value) {
        if (keyBytes == null) {
            throw new IllegalArgumentException("Can not write a null key");
        }
        if (this.oneTransactionsData == null) {
            throw new IllegalStateException("Trying to write to a HalfDiskHashMap when you have not called startWriting().");
        }
        if (Thread.currentThread() != this.writingThread) {
            throw new IllegalStateException("Tried to write with different thread to startWriting()");
        }
        int bucketIndex = this.computeBucketIndex(keyHashCode);
        return (BucketMutation)this.oneTransactionsData.getIfAbsentPut(bucketIndex, (Function0 & Serializable)() -> new BucketMutation(keyBytes, keyHashCode, oldValue, value));
    }

    public void put(Bytes keyBytes, long value) {
        this.put(keyBytes, keyBytes.hashCode(), value);
    }

    void put(Bytes keyBytes, int keyHashCode, long value) {
        BucketMutation bucketMap = this.findBucketForUpdate(keyBytes, keyHashCode, Long.MIN_VALUE, value);
        bucketMap.put(keyBytes, keyHashCode, value);
    }

    public void putIfEqual(Bytes keyBytes, long oldValue, long value) {
        this.putIfEqual(keyBytes, keyBytes.hashCode(), oldValue, value);
    }

    void putIfEqual(Bytes keyBytes, int keyHashCode, long oldValue, long value) {
        BucketMutation bucketMap = this.findBucketForUpdate(keyBytes, keyHashCode, oldValue, value);
        bucketMap.putIfEqual(keyBytes, keyHashCode, oldValue, value);
    }

    public void delete(Bytes keyBytes) {
        this.put(keyBytes, Long.MIN_VALUE);
    }

    public void deleteIfEqual(Bytes keyBytes, long oldValue) {
        this.putIfEqual(keyBytes, oldValue, Long.MIN_VALUE);
    }

    private void resetEndWriting(ForkJoinPool pool, int size) {
        this.exceptionOccurred.set(null);
        this.updatedBucketsCount.set(size);
        this.bucketPermits.set(1024);
        this.lastStoreTask.set(null);
        this.storeBucketTasksCreated.set(0);
        this.notifyTaskRef.set(new NotifyTask(pool));
    }

    @Nullable
    public DataFileReader endWriting() throws IOException {
        DataFileReader dataFileReader;
        if (Thread.currentThread() != this.writingThread) {
            throw new IllegalStateException("Tried calling endWriting with different thread to startWriting()");
        }
        int size = this.oneTransactionsData.size();
        if (logger.isDebugEnabled(LogMarker.MERKLE_DB.getMarker())) {
            logger.debug(LogMarker.MERKLE_DB.getMarker(), "Finishing writing to {}, num of changed bins = {}, num of changed keys = {}", (Object)this.storeName, (Object)size, (Object)this.oneTransactionsData.stream().mapToLong(BucketMutation::size).sum());
        }
        try {
            if (size > 0) {
                Iterator it = this.oneTransactionsData.keyValuesView().iterator();
                this.fileCollection.startWriting();
                ForkJoinPool pool = HalfDiskHashMap.getFlushingPool(this.config);
                this.resetEndWriting(pool, size);
                SubmitTask submitTask = new SubmitTask(pool, it, 1);
                this.currentSubmitTask.set(submitTask);
                submitTask.send();
                this.notifyTaskRef.get().join();
                if (this.exceptionOccurred.get() != null) {
                    throw new IOException(this.exceptionOccurred.get());
                }
                dataFileReader = this.fileCollection.endWriting();
                logger.info(LogMarker.MERKLE_DB.getMarker(), "Finished writing to {}, newFile={}, numOfFiles={}, minimumValidKey={}, maximumValidKey={}", (Object)this.storeName, (Object)dataFileReader.getIndex(), (Object)this.fileCollection.getNumOfFiles(), (Object)0, (Object)(this.numOfBuckets.get() - 1));
            } else {
                dataFileReader = null;
            }
        }
        catch (Exception z) {
            throw new RuntimeException("Exception in HDHM.endWriting()", z);
        }
        finally {
            this.writingThread = null;
            this.oneTransactionsData = null;
            this.currentSubmitTask.set(null);
        }
        return dataFileReader;
    }

    private void bucketProcessed() {
        if (this.bucketPermits.getAndIncrement() == 0) {
            this.currentSubmitTask.get().notifyBucketProcessed();
        }
    }

    public long get(Bytes keyBytes, long notFoundValue) throws IOException {
        return this.get(keyBytes, keyBytes.hashCode(), notFoundValue);
    }

    public long get(Bytes keyBytes, int keyHashCode, long notFoundValue) throws IOException {
        if (keyBytes == null) {
            throw new IllegalArgumentException("Can not get a null key");
        }
        int bucketIndex = this.computeBucketIndex(keyHashCode);
        try (Bucket bucket = this.readBucket(bucketIndex);){
            if (bucket != null) {
                long l = bucket.findValue(keyHashCode, keyBytes, notFoundValue);
                return l;
            }
        }
        return notFoundValue;
    }

    private Bucket readBucket(int bucketIndex) throws IOException {
        BufferedData bucketData = this.fileCollection.readDataItemUsingIndex(this.bucketIndexToBucketLocation, bucketIndex);
        if (bucketData == null) {
            return null;
        }
        Bucket bucket = this.bucketPool.getBucket();
        bucket.readFrom((ReadableSequentialData)bucketData);
        return bucket;
    }

    public void resizeIfNeeded(long firstLeafPath, long lastLeafPath) {
        long currentSize = lastLeafPath - firstLeafPath + 1L;
        if (currentSize / (long)this.numOfBuckets.get() * 100L <= (long)this.goodAverageBucketEntryCount * 70L) {
            return;
        }
        int oldSize = this.numOfBuckets.get();
        int newSize = oldSize * 2;
        logger.info(LogMarker.MERKLE_DB.getMarker(), "Resize HDHM {} to {} buckets", (Object)this.storeName, (Object)newSize);
        this.bucketIndexToBucketLocation.updateValidRange(0L, newSize - 1);
        for (int i = 0; i < oldSize; ++i) {
            long value = this.bucketIndexToBucketLocation.get(i);
            if (value == 0L) continue;
            this.bucketIndexToBucketLocation.put(i + oldSize, value);
        }
        this.fileCollection.updateValidKeyRange(0L, newSize - 1);
        this.setNumberOfBuckets(newSize);
        logger.info(LogMarker.MERKLE_DB.getMarker(), "Resize HDHM {} to {} buckets done", (Object)this.storeName, (Object)newSize);
    }

    public void printStats() {
        logger.info(LogMarker.MERKLE_DB.getMarker(), "HalfDiskHashMap Stats {\n\tnumOfBuckets = {}\n\tgoodAverageBucketEntryCount = {}\n}", (Object)this.numOfBuckets, (Object)this.goodAverageBucketEntryCount);
    }

    public DataFileCollection getFileCollection() {
        return this.fileCollection;
    }

    public CASableLongIndex getBucketIndexToBucketLocation() {
        return this.bucketIndexToBucketLocation;
    }

    private void setNumberOfBuckets(int newValue) {
        this.numOfBuckets.set(newValue);
        int trailingZeroes = Integer.numberOfTrailingZeros(newValue);
        this.bucketMaskBits.set(trailingZeroes);
    }

    int getNumOfBuckets() {
        return this.numOfBuckets.get();
    }

    private int computeBucketIndex(int keyHash) {
        return this.numOfBuckets.get() - 1 & keyHash;
    }

    private static class NotifyTask
    extends AbstractTask {
        NotifyTask(ForkJoinPool pool) {
            super(pool, 1);
        }

        protected boolean onExecute() {
            return true;
        }
    }

    private class SubmitTask
    extends AbstractTask {
        private final Iterator<IntObjectPair<BucketMutation>> it;

        SubmitTask(ForkJoinPool pool, Iterator<IntObjectPair<BucketMutation>> it, int depCount) {
            super(pool, depCount);
            this.it = it;
        }

        void notifyBucketProcessed() {
            this.send();
        }

        protected boolean onExecute() {
            SubmitTask nextSubmitTask = new SubmitTask(SubmitTask.getPool(), this.it, 2);
            boolean newSubmitTaskSet = HalfDiskHashMap.this.currentSubmitTask.compareAndSet(this, nextSubmitTask);
            assert (newSubmitTaskSet);
            int maxToSubmit = HalfDiskHashMap.this.bucketPermits.getAndSet(0);
            assert (maxToSubmit > 0);
            while (this.it.hasNext() && maxToSubmit-- > 0) {
                IntObjectPair<BucketMutation> keyValue = this.it.next();
                int bucketIndex = keyValue.getOne();
                BucketMutation bucketMap = (BucketMutation)keyValue.getTwo();
                ReadUpdateBucketTask readBucketTask = new ReadUpdateBucketTask(SubmitTask.getPool(), bucketIndex, bucketMap);
                readBucketTask.send();
            }
            if (this.it.hasNext()) {
                nextSubmitTask.send();
            }
            return true;
        }
    }

    public class StoreBucketTask
    extends AbstractTask {
        private final Bucket bucket;
        private AbstractTask next;

        StoreBucketTask(ForkJoinPool pool, Bucket bucket) {
            super(pool, 2);
            this.bucket = bucket;
        }

        void setNext(AbstractTask next) {
            this.next = next;
            this.send();
        }

        protected boolean onExecute() throws IOException {
            try {
                boolean bl;
                block11: {
                    Bucket bucket = this.bucket;
                    try {
                        int bucketIndex = this.bucket.getBucketIndex();
                        if (this.bucket.isEmpty()) {
                            HalfDiskHashMap.this.bucketIndexToBucketLocation.remove(bucketIndex);
                        } else {
                            long bucketLocation = HalfDiskHashMap.this.fileCollection.storeDataItem(this.bucket::writeTo, this.bucket.sizeInBytes());
                            HalfDiskHashMap.this.bucketIndexToBucketLocation.put(bucketIndex, bucketLocation);
                        }
                        bl = true;
                        if (bucket == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (bucket != null) {
                            try {
                                bucket.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    bucket.close();
                }
                return bl;
            }
            finally {
                HalfDiskHashMap.this.bucketProcessed();
                this.next.send();
            }
        }

        protected void onException(Throwable t) {
            logger.error(LogMarker.MERKLE_DB.getMarker(), "Failed to write bucket " + this.bucket.getBucketIndex(), t);
            HalfDiskHashMap.this.exceptionOccurred.set(t);
            HalfDiskHashMap.this.notifyTaskRef.get().completeExceptionally(t);
        }
    }

    private class ReadUpdateBucketTask
    extends AbstractTask {
        private final int bucketIndex;
        private final BucketMutation keyUpdates;

        ReadUpdateBucketTask(ForkJoinPool pool, int bucketIndex, BucketMutation keyUpdates) {
            super(pool, 0);
            this.bucketIndex = bucketIndex;
            this.keyUpdates = keyUpdates;
        }

        private void createAndScheduleStoreTask(Bucket bucket, boolean bucketChanged) throws IOException {
            if (bucketChanged) {
                StoreBucketTask storeTask = new StoreBucketTask(ReadUpdateBucketTask.getPool(), bucket);
                StoreBucketTask prevTask = HalfDiskHashMap.this.lastStoreTask.getAndSet(storeTask);
                if (prevTask != null) {
                    prevTask.setNext(storeTask);
                } else {
                    storeTask.send();
                }
            } else {
                bucket.close();
                HalfDiskHashMap.this.bucketProcessed();
            }
            if (HalfDiskHashMap.this.storeBucketTasksCreated.incrementAndGet() == HalfDiskHashMap.this.updatedBucketsCount.get()) {
                StoreBucketTask lastTask = HalfDiskHashMap.this.lastStoreTask.get();
                if (lastTask != null) {
                    lastTask.setNext(HalfDiskHashMap.this.notifyTaskRef.get());
                } else {
                    HalfDiskHashMap.this.notifyTaskRef.get().send();
                }
            }
        }

        protected boolean onExecute() throws IOException {
            BufferedData bucketData = HalfDiskHashMap.this.fileCollection.readDataItemUsingIndex(HalfDiskHashMap.this.bucketIndexToBucketLocation, this.bucketIndex);
            Bucket bucket = HalfDiskHashMap.this.bucketPool.getBucket();
            boolean bucketChanged = false;
            if (bucketData == null) {
                bucket.setBucketIndex(this.bucketIndex);
                assert (this.keyUpdates != null);
                for (BucketMutation m = this.keyUpdates; m != null; m = m.getNext()) {
                    assert (m.getOldValue() == Long.MIN_VALUE);
                    if (m.getValue() == Long.MIN_VALUE) continue;
                    bucket.addValue(m.getKeyBytes(), m.getKeyHashCode(), m.getValue());
                }
                bucketChanged = true;
            } else {
                bucket.readFrom((ReadableSequentialData)bucketData);
                if ((bucket.getBucketIndex() & this.bucketIndex) != bucket.getBucketIndex()) {
                    logger.error(LogMarker.MERKLE_DB.getMarker(), "Bucket index integrity check " + this.bucketIndex + " != " + bucket.getBucketIndex());
                    bucket.clear();
                }
                for (BucketMutation m = this.keyUpdates; m != null; m = m.getNext()) {
                    if (!bucket.putValue(m.getKeyBytes(), m.getKeyHashCode(), m.getOldValue(), m.getValue())) continue;
                    bucketChanged = true;
                }
                if (bucketChanged) {
                    bucket.sanitize(this.bucketIndex, HalfDiskHashMap.this.bucketMaskBits.get());
                }
            }
            this.createAndScheduleStoreTask(bucket, bucketChanged);
            return true;
        }

        protected void onException(Throwable t) {
            logger.error(LogMarker.MERKLE_DB.getMarker(), "Failed to read / update bucket {}, location {}", (Object)this.bucketIndex, (Object)DataFileCommon.dataLocationToString(HalfDiskHashMap.this.bucketIndexToBucketLocation.get(this.bucketIndex)), (Object)t);
            HalfDiskHashMap.this.exceptionOccurred.set(t);
            HalfDiskHashMap.this.notifyTaskRef.get().completeExceptionally(t);
        }
    }
}

