/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkle.test.fixtures.map.pta;

import com.swirlds.common.FastCopyable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.hiero.base.crypto.AbstractSerializableHashable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class TransactionRecord
extends AbstractSerializableHashable
implements FastCopyable,
Serializable {
    private static final long CLASS_ID = -3614792476105980712L;
    private static final int MAX_CONTENT_LENGTH = 102400;
    public static final int DEFAULT_EXPIRATION_TIME = 180;
    private static final int EXPIRATION_VERSION = 2;
    private long index;
    private long balance;
    private byte[] content;
    private long expirationTime;
    private boolean immutable;

    public TransactionRecord() {
    }

    public TransactionRecord(long index, long balance, byte[] content, long expirationTime) {
        this.index = index;
        this.balance = balance;
        this.content = content;
        this.expirationTime = expirationTime;
    }

    private TransactionRecord(TransactionRecord sourceTransaction) {
        this.index = sourceTransaction.index;
        this.balance = sourceTransaction.balance;
        if (sourceTransaction.content != null) {
            this.content = Arrays.copyOf(sourceTransaction.content, sourceTransaction.content.length);
        }
        this.expirationTime = sourceTransaction.expirationTime;
    }

    public long getIndex() {
        return this.index;
    }

    public long getBalance() {
        return this.balance;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public TransactionRecord copy() {
        this.throwIfImmutable();
        return new TransactionRecord(this);
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.index);
        out.writeLong(this.balance);
        out.writeByteArray(this.content);
        out.writeLong(this.expirationTime);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.index = in.readLong();
        this.balance = in.readLong();
        this.content = in.readByteArray(102400);
        if (version >= 2) {
            this.expirationTime = in.readLong();
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransactionRecord that = (TransactionRecord)other;
        return this.index == that.index && this.balance == that.balance && this.expirationTime == that.expirationTime && Arrays.equals(this.content, that.content);
    }

    public int hashCode() {
        int result = Objects.hash(this.index, this.balance, this.expirationTime);
        result = 31 * result + Arrays.hashCode(this.content);
        return result;
    }

    public long getClassId() {
        return -3614792476105980712L;
    }

    public int getVersion() {
        return 2;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;
        public static final int ADD_EXPIRATION_TIME = 2;

        private ClassVersion() {
        }
    }
}

