/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform;

import com.swirlds.demo.platform.PAYLOAD_TYPE;
import com.swirlds.demo.platform.PayloadDistribution;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class PayloadConfig {
    public static final byte APPLICATION_TRANSACTION_MARKER = 1;
    private static final Logger logger = LogManager.getLogger(PayloadConfig.class);
    private static final Marker MARKER = MarkerManager.getMarker((String)"DEMO_INFO");
    private static final Marker ERROR = MarkerManager.getMarker((String)"EXCEPTION");
    private boolean insertSeq = false;
    private boolean appendSig = false;
    private double invalidSigRatio = 0.0;
    private final float ratioOfFCMTransaction;
    private boolean performOnDeleted = true;
    private boolean createOnExistingEntities = false;
    private boolean performOnNonExistingEntities = true;
    private final boolean operateEntitiesOfSameNode = false;
    private boolean variedSize = false;
    private int payloadByteSize = 100;
    private int maxByteSize = 100;
    private PAYLOAD_TYPE type = PAYLOAD_TYPE.TYPE_RANDOM_BYTES;
    private PayloadDistribution distribution = null;

    private PayloadConfig(Builder builder) {
        this.insertSeq = builder.insertSeq;
        this.appendSig = builder.appendSig;
        this.variedSize = builder.variedSize;
        this.payloadByteSize = builder.payloadByteSize;
        this.maxByteSize = builder.maxByteSize;
        this.type = builder.type;
        this.distribution = builder.distribution;
        this.invalidSigRatio = builder.invalidSigRatio;
        this.createOnExistingEntities = builder.createOnExistingEntities;
        this.performOnDeleted = builder.performOnDeleted;
        this.performOnNonExistingEntities = builder.performOnNonExistingEntities;
        this.ratioOfFCMTransaction = builder.ratioOfFCMTransaction;
    }

    public boolean isInsertSeq() {
        return this.insertSeq;
    }

    public boolean isAppendSig() {
        return this.appendSig;
    }

    public PAYLOAD_TYPE getType() {
        return this.type;
    }

    public int getPayloadByteSize() {
        return this.payloadByteSize;
    }

    public boolean isVariedSize() {
        return this.variedSize;
    }

    public int getMaxByteSize() {
        return this.maxByteSize;
    }

    public PayloadDistribution getPayloadDistribution() {
        return this.distribution;
    }

    public double getInvalidSigRatio() {
        return this.invalidSigRatio;
    }

    public void setPerformOnDeleted(boolean performOnDeleted) {
        this.performOnDeleted = performOnDeleted;
    }

    public boolean isPerformOnDeleted() {
        return this.performOnDeleted;
    }

    public boolean isCreateOnExistingEntities() {
        return this.createOnExistingEntities;
    }

    public boolean isPerformOnNonExistingEntities() {
        return this.performOnNonExistingEntities;
    }

    public boolean isOperateEntitiesOfSameNode() {
        return false;
    }

    public float getRatioOfFCMTransaction() {
        return this.ratioOfFCMTransaction;
    }

    public void display() {
        logger.info(MARKER, " insertSeq         = " + this.insertSeq);
        logger.info(MARKER, " appendSig         = " + this.appendSig);
        logger.info(MARKER, " variedSize        = " + this.variedSize);
        logger.info(MARKER, " payloadByteSize   = " + this.payloadByteSize);
        logger.info(MARKER, " maxByteSize       = " + this.maxByteSize);
        logger.info(MARKER, " type              = " + String.valueOf((Object)this.type));
        logger.info(MARKER, " invalidSigRatio   = " + this.invalidSigRatio);
        if (this.distribution != null) {
            this.distribution.display();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean insertSeq;
        private boolean appendSig;
        private boolean variedSize;
        private int payloadByteSize = 100;
        private int maxByteSize = 100;
        private PAYLOAD_TYPE type = PAYLOAD_TYPE.TYPE_RANDOM_BYTES;
        private PayloadDistribution distribution = null;
        private double invalidSigRatio = 0.0;
        private float ratioOfFCMTransaction = 0.0f;
        private boolean performOnDeleted = true;
        private boolean createOnExistingEntities = false;
        private boolean performOnNonExistingEntities = true;
        private boolean operateEntitiesOfSameNode = false;

        private Builder() {
        }

        public Builder setInsertSeq(boolean insertSeq) {
            this.insertSeq = insertSeq;
            return this;
        }

        public Builder setAppendSig(boolean appendSig) {
            this.appendSig = appendSig;
            return this;
        }

        public Builder setVariedSize(boolean variedSize) {
            this.variedSize = variedSize;
            return this;
        }

        public Builder setPayloadByteSize(int payloadByteSize) {
            this.payloadByteSize = payloadByteSize;
            return this;
        }

        public Builder setMaxByteSize(int maxByteSize) {
            this.maxByteSize = maxByteSize;
            return this;
        }

        public Builder setType(PAYLOAD_TYPE type) {
            this.type = type;
            return this;
        }

        public Builder setDistribution(PayloadDistribution distribution) {
            this.distribution = distribution;
            return this;
        }

        public Builder setInvalidSigRatio(double invalidSigRatio) {
            this.invalidSigRatio = invalidSigRatio;
            return this;
        }

        public Builder setRatioOfFCMTransaction(float ratioOfFCMTransaction) {
            this.ratioOfFCMTransaction = ratioOfFCMTransaction;
            return this;
        }

        public Builder setPerformOnDeleted(boolean performOnDeleted) {
            this.performOnDeleted = performOnDeleted;
            return this;
        }

        public Builder setCreateOnExistingEntities(boolean createOnExistingEntities) {
            this.createOnExistingEntities = createOnExistingEntities;
            return this;
        }

        public Builder setPerformOnNonExistingEntities(boolean performOnNonExistingEntities) {
            this.performOnNonExistingEntities = performOnNonExistingEntities;
            return this;
        }

        public Builder setOperateEntitiesOfSameNode(boolean operateEntitiesOfSameNode) {
            this.operateEntitiesOfSameNode = operateEntitiesOfSameNode;
            return this;
        }

        public PayloadConfig build() {
            return new PayloadConfig(this);
        }
    }
}

