/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.test.fixtures.platform.TestPlatformContextBuilder;
import com.swirlds.config.extensions.test.fixtures.TestConfigBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.io.TempDir;

public abstract class PlatformTest {
    public static final String TEST_MARKER_FILE_DIRECTORY = "marker_files";
    @TempDir
    protected Path tempDir;

    @NonNull
    protected PlatformContext createDefaultPlatformContext() {
        return this.createPlatformContext(null, null);
    }

    @NonNull
    protected PlatformContext createPlatformContext(@Nullable Function<TestPlatformContextBuilder, TestPlatformContextBuilder> platformContextModifier, @Nullable Function<TestConfigBuilder, TestConfigBuilder> configModifier) {
        TestPlatformContextBuilder platformContextBuilder = TestPlatformContextBuilder.create();
        TestConfigBuilder configBuilder = new TestConfigBuilder();
        if (configModifier != null) {
            configModifier.apply(configBuilder);
        }
        configBuilder.withValue("paths.markerFilesDir", this.tempDir.resolve(TEST_MARKER_FILE_DIRECTORY).toString()).withValue("paths.writePlatformMarkerFiles", true);
        platformContextBuilder.withConfiguration(configBuilder.getOrCreateConfig());
        if (platformContextModifier != null) {
            platformContextModifier.apply(platformContextBuilder);
        }
        return platformContextBuilder.build();
    }

    @NonNull
    Path getTempDir() {
        return Objects.requireNonNull(this.tempDir);
    }

    @NonNull
    protected Path getMarkerFileDirectory() {
        return Objects.requireNonNull(this.tempDir.resolve(TEST_MARKER_FILE_DIRECTORY));
    }

    protected void assertMarkerFile(@NonNull String markerFileName, boolean exists) {
        Assertions.assertThat((boolean)exists).isEqualTo(this.getMarkerFileDirectory().resolve(markerFileName).toFile().exists()).withFailMessage("Marker file " + markerFileName + " should " + (exists ? "" : "not ") + "exist", new Object[0]);
    }
}

