/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.event.generator;

import com.swirlds.platform.internal.EventImpl;
import com.swirlds.platform.test.fixtures.event.generator.GraphGenerator;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.hiero.consensus.model.node.NodeId;

public abstract class AbstractGraphGenerator
implements GraphGenerator {
    private long numEventsGenerated;
    private final long initialSeed;
    private Random random;
    private final Map<NodeId, Long> maxBirthRoundPerCreator;

    protected AbstractGraphGenerator(long initialSeed) {
        this.initialSeed = initialSeed;
        this.random = new Random(initialSeed);
        this.maxBirthRoundPerCreator = new HashMap<NodeId, Long>();
    }

    protected abstract void resetInternalData();

    @Override
    public final void reset() {
        this.numEventsGenerated = 0L;
        this.random = new Random(this.initialSeed);
        this.maxBirthRoundPerCreator.clear();
        this.resetInternalData();
    }

    protected abstract EventImpl buildNextEvent(long var1);

    @Override
    public final EventImpl generateEvent() {
        EventImpl next = this.generateEventWithoutIndex();
        return next;
    }

    public final EventImpl generateEventWithoutIndex() {
        EventImpl next = this.buildNextEvent(this.numEventsGenerated);
        next.getBaseEvent().signalPrehandleCompletion();
        ++this.numEventsGenerated;
        this.updateMaxBirthRound(next);
        return next;
    }

    @Override
    public final long getNumEventsGenerated() {
        return this.numEventsGenerated;
    }

    protected final Random getRandom() {
        return this.random;
    }

    public final long getInitialSeed() {
        return this.initialSeed;
    }

    private void updateMaxBirthRound(@NonNull EventImpl event) {
        this.maxBirthRoundPerCreator.merge(event.getCreatorId(), event.getBirthRound(), Math::max);
    }

    @Override
    public long getMaxBirthRound(@Nullable NodeId creatorId) {
        return this.maxBirthRoundPerCreator.getOrDefault(creatorId, 0L);
    }
}

