/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.gui;

import com.swirlds.platform.internal.EventImpl;
import com.swirlds.platform.test.fixtures.event.generator.GraphGenerator;
import com.swirlds.platform.test.fixtures.event.source.EventSource;
import com.swirlds.platform.test.fixtures.gui.GuiEventProvider;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.node.NodeId;

public class GeneratorEventProvider
implements GuiEventProvider {
    private final GraphGenerator graphGenerator;

    public GeneratorEventProvider(@NonNull GraphGenerator graphGenerator) {
        Objects.requireNonNull(graphGenerator);
        this.graphGenerator = graphGenerator;
    }

    @Override
    @NonNull
    public List<PlatformEvent> provideEvents(int numberOfEvents) {
        return this.graphGenerator.generateEvents(numberOfEvents).stream().map(EventImpl::getBaseEvent).toList();
    }

    @Override
    public void reset() {
        this.graphGenerator.reset();
    }

    public EventSource getNodeSource(@NonNull NodeId nodeID) {
        return this.graphGenerator.getSource(nodeID);
    }
}

