/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.observers;

import com.swirlds.platform.test.fixtures.observers.ObservationType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hiero.consensus.model.hashgraph.ConsensusRound;

public class SimpleConsensusRoundTracker {
    private final Map<ObservationType, Set<Long>> consensusRoundsObserved = new HashMap<ObservationType, Set<Long>>();

    public SimpleConsensusRoundTracker() {
        for (ObservationType type : ObservationType.values()) {
            this.consensusRoundsObserved.put(type, new HashSet());
        }
    }

    public void observe(ObservationType observation, ConsensusRound consensusRound) {
        if (this.isObserved(observation, consensusRound)) {
            throw new RuntimeException("Consensus round should not be observed twice");
        }
    }

    public boolean isObserved(ObservationType observation, ConsensusRound consensusRound) {
        return this.consensusRoundsObserved.get((Object)observation).contains(consensusRound.getRoundNum());
    }

    public void clear() {
        for (Set<Long> value : this.consensusRoundsObserved.values()) {
            value.clear();
        }
    }
}

