/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.event.preconsensus;

import com.swirlds.base.time.Time;
import com.swirlds.common.metrics.IntegerPairAccumulator;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;

class PcesWriterPerEventMetrics {
    private static final IntegerPairAccumulator.Config<Double> PCES_AVG_EVENT_SIZE = new IntegerPairAccumulator.Config("platform", "pcesAvgEventSize", Double.class, IntegerPairAccumulator.AVERAGE).withDescription("The average length in bytes of an event written in a pces file");
    private static final IntegerPairAccumulator.Config<Double> PCES_AVG_SYNC_DURATION = new IntegerPairAccumulator.Config("platform", "pcesAvgSyncDuration", Double.class, IntegerPairAccumulator.AVERAGE).withDescription("The amount of time it takes to complete a flush operation");
    private static final IntegerPairAccumulator.Config<Double> PCES_AVG_WRITE_DURATION = new IntegerPairAccumulator.Config("platform", "pcesAvgWriteDuration", Double.class, IntegerPairAccumulator.AVERAGE).withDescription("The amount of time it takes to complete a single write operation");
    private static final IntegerPairAccumulator.Config<Double> PCES_AVG_TOTAL_WRITE_DURATION = new IntegerPairAccumulator.Config("platform", "pcesAvgTotalWriteDuration", Double.class, IntegerPairAccumulator.AVERAGE).withDescription("The amount of time it takes to write a single event to the stream");
    private final IntegerPairAccumulator<Double> avgWriteMetric;
    private final IntegerPairAccumulator<Double> avgSyncMetric;
    private final IntegerPairAccumulator<Double> avgTotalWrite;
    private final IntegerPairAccumulator<Double> avgEventSizeMetric;
    private final Time time;
    private long totalWriteStart;
    private long writeStart;
    private long syncStart;

    PcesWriterPerEventMetrics(@NonNull Metrics metrics, @NonNull Time time) {
        this.avgWriteMetric = (IntegerPairAccumulator)metrics.getOrCreate(PCES_AVG_WRITE_DURATION);
        this.avgSyncMetric = (IntegerPairAccumulator)metrics.getOrCreate(PCES_AVG_SYNC_DURATION);
        this.avgTotalWrite = (IntegerPairAccumulator)metrics.getOrCreate(PCES_AVG_TOTAL_WRITE_DURATION);
        this.avgEventSizeMetric = (IntegerPairAccumulator)metrics.getOrCreate(PCES_AVG_EVENT_SIZE);
        this.time = time;
    }

    void startWriteEvent() {
        this.totalWriteStart = this.time.nanoTime();
    }

    void startFileSync() {
        this.syncStart = this.time.nanoTime();
    }

    void startFileWrite() {
        this.writeStart = this.time.nanoTime();
    }

    void endFileWrite(long size) {
        this.avgWriteMetric.update(this.getDurationInNanos(this.writeStart), 1);
        this.avgEventSizeMetric.update(PcesWriterPerEventMetrics.asInt(size), 1);
    }

    void endWriteEvent() {
        this.avgTotalWrite.update(this.getDurationInNanos(this.totalWriteStart), 1);
    }

    void endFileSync() {
        this.avgSyncMetric.update(this.getDurationInNanos(this.syncStart), 1);
    }

    void clear() {
        this.totalWriteStart = 0L;
        this.writeStart = 0L;
        this.syncStart = 0L;
    }

    private int getDurationInNanos(long startNanos) {
        long val = this.time.nanoTime() - startNanos;
        return PcesWriterPerEventMetrics.asInt(val);
    }

    private static int asInt(long val) {
        return val > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)val;
    }
}

