/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.system;

import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.swirlds.base.time.Time;
import com.swirlds.common.metrics.noop.NoOpMetrics;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.system.SwirldMain;
import com.swirlds.state.MerkleNodeState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.InstantSource;
import java.util.List;
import org.hiero.consensus.model.status.PlatformStatus;
import org.hiero.consensus.model.transaction.TimestampedTransaction;
import org.hiero.consensus.transaction.TransactionPoolNexus;

public abstract class DefaultSwirldMain<T extends MerkleNodeState>
implements SwirldMain<T> {
    private static final int TX_QUEUE_SIZE = 100000;
    private final TransactionPoolNexus transactionPool = new TransactionPoolNexus(this.getTransactionLimits(), 100000, (Metrics)new NoOpMetrics(), (InstantSource)Time.getCurrent());

    @Override
    public void submitStateSignature(@NonNull StateSignatureTransaction transaction) {
        this.transactionPool.submitPriorityTransaction(StateSignatureTransaction.PROTOBUF.toBytes((Object)transaction));
    }

    @NonNull
    public List<TimestampedTransaction> getTransactionsForEvent() {
        return this.transactionPool.getTransactionsForEvent();
    }

    public boolean hasBufferedSignatureTransactions() {
        return this.transactionPool.hasBufferedSignatureTransactions();
    }

    @Override
    public void newPlatformStatus(@NonNull PlatformStatus platformStatus) {
        this.transactionPool.updatePlatformStatus(platformStatus);
    }

    @NonNull
    public TransactionPoolNexus getTransactionPool() {
        return this.transactionPool;
    }

    @Override
    public void reportUnhealthyDuration(@NonNull Duration duration) {
        this.transactionPool.reportUnhealthyDuration(duration);
    }
}

