/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.io.extendable;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import java.util.function.Function;
import org.hiero.base.utility.test.fixtures.RandomUtils;
import org.hiero.base.utility.test.fixtures.ResettableRandom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public final class StreamSanityChecks {
    private StreamSanityChecks() {
    }

    private static void assertArraySegmentsMatch(byte[] a, int aOffset, byte[] b, int bOffset, int length) {
        for (int index = 0; index < length; ++index) {
            Assertions.assertEquals((byte)a[aOffset + index], (byte)b[bOffset + index], (String)"byte does not match");
        }
    }

    private static int testRead(InputStream in, byte[] expectedBytes, int index) throws IOException {
        byte b = (byte)in.read();
        Assertions.assertEquals((byte)expectedBytes[index], (byte)b, (String)"byte should match");
        return index + 1;
    }

    private static int testReadIntoArray(Random random, InputStream in, byte[] expectedBytes, int index) throws IOException {
        int bytesToRead = (int)(random.nextDouble() * (double)(expectedBytes.length / 10));
        int expectedBytesRead = Math.min(bytesToRead, expectedBytes.length - index);
        int offset = (int)(random.nextDouble() * 10.0);
        byte[] b = new byte[bytesToRead + offset];
        int bytesActuallyRead = in.read(b, offset, bytesToRead);
        if (bytesActuallyRead == -1) {
            Assertions.assertEquals((int)0, (int)expectedBytesRead, (String)"there should be no more bytes to read");
            return index;
        }
        Assertions.assertEquals((int)expectedBytesRead, (int)bytesActuallyRead, (String)"expected number of bytes should have been read");
        StreamSanityChecks.assertArraySegmentsMatch(expectedBytes, index, b, offset, expectedBytesRead);
        return index + expectedBytesRead;
    }

    private static int testReadNBytes(Random random, InputStream in, byte[] expectedBytes, int index) throws IOException {
        int bytesToRead = (int)(random.nextDouble() * (double)(expectedBytes.length / 10));
        int expectedBytesRead = Math.min(bytesToRead, expectedBytes.length - index);
        byte[] b = in.readNBytes(bytesToRead);
        Assertions.assertEquals((int)expectedBytesRead, (int)b.length, (String)"expected number of bytes should have been read");
        StreamSanityChecks.assertArraySegmentsMatch(expectedBytes, index, b, 0, expectedBytesRead);
        return index + expectedBytesRead;
    }

    private static int testReadNBytesIntoArray(Random random, InputStream in, byte[] expectedBytes, int index) throws IOException {
        int bytesToRead = (int)(random.nextDouble() * (double)(expectedBytes.length / 10));
        int expectedBytesRead = Math.min(bytesToRead, expectedBytes.length - index);
        int offset = (int)(random.nextDouble() * 10.0);
        byte[] b = new byte[bytesToRead + offset];
        int bytesActuallyRead = in.readNBytes(b, offset, bytesToRead);
        Assertions.assertEquals((int)expectedBytesRead, (int)bytesActuallyRead, (String)"expected number of bytes should have been read");
        StreamSanityChecks.assertArraySegmentsMatch(expectedBytes, index, b, offset, expectedBytesRead);
        return index + expectedBytesRead;
    }

    public static void inputStreamSanityCheck(Function<InputStream, InputStream> streamBuilder) throws IOException {
        ResettableRandom random = RandomUtils.getRandomPrintSeed();
        int dataSize = 1024;
        int iterations = 1024;
        for (int iteration = 0; iteration < 1024; ++iteration) {
            byte[] bytes = new byte[1024];
            random.nextBytes(bytes);
            ByteArrayInputStream baseIn = new ByteArrayInputStream(bytes);
            InputStream in = streamBuilder.apply(baseIn);
            int index = 0;
            while (index < 1024) {
                if (random.nextBoolean()) {
                    index = StreamSanityChecks.testRead(in, bytes, index);
                }
                if (random.nextBoolean()) {
                    index = StreamSanityChecks.testReadIntoArray((Random)random, in, bytes, index);
                }
                if (random.nextBoolean()) {
                    index = StreamSanityChecks.testReadNBytes((Random)random, in, bytes, index);
                }
                if (!random.nextBoolean()) continue;
                index = StreamSanityChecks.testReadNBytesIntoArray((Random)random, in, bytes, index);
            }
            Assertions.assertEquals((int)-1, (int)in.read(), (String)"stream should be closed");
            Assertions.assertEquals((int)-1, (int)in.read(new byte[10], 0, 10), (String)"stream should be closed");
            byte[] b = in.readNBytes(100);
            Assertions.assertEquals((int)0, (int)b.length, (String)"stream should have no bytes remaining");
            Assertions.assertEquals((int)0, (int)in.readNBytes(new byte[10], 0, 10), (String)"stream should have no bytes remaining");
            in.close();
        }
    }

    public static void outputStreamSanityCheck(Function<OutputStream, OutputStream> streamBuilder) throws IOException {
        ResettableRandom random = RandomUtils.getRandomPrintSeed();
        int dataSize = 1024;
        int iterations = 1024;
        for (int iteration = 0; iteration < 1024; ++iteration) {
            byte[] bytes = new byte[1024];
            random.nextBytes(bytes);
            ByteArrayOutputStream baseOut = new ByteArrayOutputStream();
            OutputStream out = streamBuilder.apply(baseOut);
            int index = 0;
            while (index < 1024) {
                if (random.nextBoolean()) {
                    out.write(bytes[index++]);
                }
                if (!random.nextBoolean()) continue;
                int bytesToWrite = Math.min(1024 - index, (int)(random.nextDouble() * 102.0));
                out.write(bytes, index, bytesToWrite);
                index += bytesToWrite;
            }
            byte[] resultingBytes = baseOut.toByteArray();
            Assertions.assertArrayEquals((byte[])bytes, (byte[])resultingBytes, (String)"bytes should be the same after the stream");
            out.close();
        }
    }

    @Test
    @DisplayName(value="inputStreamSanityCheck() Sanity Check")
    void inputStreamSanityCheckSanityCheck() throws IOException {
        StreamSanityChecks.inputStreamSanityCheck(stream -> stream);
    }

    @Test
    @DisplayName(value="outputStreamSanityCheck() Sanity Check")
    void outputStreamSanityCheckSanityCheck() throws IOException {
        StreamSanityChecks.outputStreamSanityCheck(stream -> stream);
    }
}

