/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.merkle.dummy;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;

public class BlockingOutputStream
extends OutputStream {
    private final AtomicBoolean locked = new AtomicBoolean(false);
    private final OutputStream out;

    public BlockingOutputStream(OutputStream out) {
        this.out = out;
    }

    public void lock() {
        this.locked.set(true);
    }

    public void unlock() {
        this.locked.set(false);
    }

    @Override
    public void write(int b) throws IOException {
        while (this.locked.get()) {
            Thread.onSpinWait();
        }
        this.out.write(b);
    }
}

