/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.disk;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.FieldType;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public record QueueState(long head, long tail) {
    private static final FieldDefinition FIELD_QUEUESTATE_HEAD = new FieldDefinition("head", FieldType.UINT64, false, true, false, 1);
    private static final FieldDefinition FIELD_QUEUESTATE_TAIL = new FieldDefinition("tail", FieldType.UINT64, false, true, false, 2);

    public QueueState {
        if (head < 0L) {
            throw new IllegalArgumentException("Head < 0");
        }
        if (tail < 0L) {
            throw new IllegalArgumentException("Tail < 0");
        }
        if (head > tail) {
            throw new IllegalArgumentException("Head > tail");
        }
    }

    public QueueState elementAdded() {
        return new QueueState(this.head, this.tail + 1L);
    }

    public QueueState elementRemoved() {
        return new QueueState(this.head + 1L, this.tail);
    }

    public static class QueueStateCodec
    implements Codec<QueueState> {
        public static final Codec<QueueState> INSTANCE = new QueueStateCodec();

        public QueueState getDefaultInstance() {
            throw new UnsupportedOperationException("getDefaultInstance() should not be used");
        }

        public int measureRecord(QueueState value) {
            int size = 0;
            if (value.head() != 0L) {
                size += ProtoWriterTools.sizeOfTag((FieldDefinition)FIELD_QUEUESTATE_HEAD);
                size += ProtoWriterTools.sizeOfVarInt64((long)value.head());
            }
            if (value.tail() != 0L) {
                size += ProtoWriterTools.sizeOfTag((FieldDefinition)FIELD_QUEUESTATE_TAIL);
                size += ProtoWriterTools.sizeOfVarInt64((long)value.tail());
            }
            return size;
        }

        public void write(@NonNull QueueState value, @NonNull WritableSequentialData out) throws IOException {
            long pos = out.position();
            if (value.head() != 0L) {
                ProtoWriterTools.writeTag((WritableSequentialData)out, (FieldDefinition)FIELD_QUEUESTATE_HEAD);
                out.writeVarLong(value.head(), false);
            }
            if (value.tail() != 0L) {
                ProtoWriterTools.writeTag((WritableSequentialData)out, (FieldDefinition)FIELD_QUEUESTATE_TAIL);
                out.writeVarLong(value.tail(), false);
            }
            assert (out.position() == pos + (long)this.measureRecord(value));
        }

        @NonNull
        public QueueState parse(@NonNull ReadableSequentialData in, boolean strictMode, boolean parseUnknownFields, int maxDepth, int maxSize) throws ParseException {
            long head = 0L;
            long tail = 0L;
            while (in.hasRemaining()) {
                int tag = in.readVarInt(false);
                int fieldNum = tag >> 3;
                int wireType = tag & 7;
                if (fieldNum == FIELD_QUEUESTATE_HEAD.number()) {
                    if (wireType != ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG.ordinal()) {
                        throw new ParseException("Head wire type mismatch: expected " + ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG.ordinal() + ", actual=" + wireType);
                    }
                    head = in.readVarLong(false);
                    continue;
                }
                if (fieldNum == FIELD_QUEUESTATE_TAIL.number()) {
                    if (wireType != ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG.ordinal()) {
                        throw new ParseException("Tail wire type mismatch: expected " + ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG.ordinal() + ", actual=" + wireType);
                    }
                    tail = in.readVarLong(false);
                    continue;
                }
                throw new ParseException("Unknown field: " + tag);
            }
            return new QueueState(head, tail);
        }

        public boolean fastEquals(@NonNull QueueState value, @NonNull ReadableSequentialData in) throws ParseException {
            return value.equals(this.parse(in));
        }

        public int measure(@NonNull ReadableSequentialData in) throws ParseException {
            long pos = in.position();
            this.parse(in);
            return (int)(in.position() - pos);
        }
    }
}

