/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.nativelib.common;

import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Optional;

public class BesuNativeLibraryLoader {
    static String[] X86_VARIANTS = new String[]{"amd64", "x86_64", "x64", "ia32e", "EMT64T"};

    public static void registerJNA(Class jnaClass, String libraryName) {
        try {
            Optional<Path> libPath = BesuNativeLibraryLoader.extract(jnaClass, libraryName);
            if (!libPath.isPresent()) {
                throw new UnsatisfiedLinkError();
            }
            NativeLibrary lib = NativeLibrary.getInstance((String)libPath.get().toString());
            Native.register((Class)jnaClass, (NativeLibrary)lib);
        }
        catch (UnsatisfiedLinkError __) {
            String exceptionMessage = String.format("Couldn't load native library (%s). It wasn't available at %s or the library path.", libraryName, BesuNativeLibraryLoader.asLibraryResourcePath(libraryName));
            throw new RuntimeException(exceptionMessage);
        }
    }

    public static void loadJNI(Class jniClass, String libraryName) {
        try {
            Optional<Path> libPath = BesuNativeLibraryLoader.extract(jniClass, libraryName);
            if (libPath.isPresent()) {
                System.load(libPath.get().toString());
            } else {
                System.loadLibrary(libraryName);
            }
        }
        catch (UnsatisfiedLinkError __) {
            String exceptionMessage = String.format("Couldn't load native library (%s). It wasn't available at %s or the library path.", libraryName, BesuNativeLibraryLoader.asLibraryResourcePath(libraryName));
            throw new RuntimeException(exceptionMessage);
        }
    }

    private static Optional<Path> extract(Class classResource, String libraryName) {
        String platformNativeLibraryName = System.mapLibraryName(libraryName);
        String libraryResourcePath = BesuNativeLibraryLoader.asLibraryResourcePath(libraryName);
        InputStream libraryResource = classResource.getResourceAsStream(libraryResourcePath);
        if (libraryResource == null) {
            libraryResource = classResource.getResourceAsStream("/" + libraryResourcePath);
        }
        if (libraryResource != null) {
            try {
                Path tempDir = Files.createTempDirectory(libraryName + "@", new FileAttribute[0]);
                tempDir.toFile().deleteOnExit();
                Path tempDll = tempDir.resolve(platformNativeLibraryName);
                tempDll.toFile().deleteOnExit();
                Files.copy(libraryResource, tempDll, StandardCopyOption.REPLACE_EXISTING);
                libraryResource.close();
                return Optional.of(tempDll);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return Optional.empty();
    }

    private static String asLibraryResourcePath(String libraryName) {
        String platformNativeLibraryName = System.mapLibraryName(libraryName);
        return BesuNativeLibraryLoader.safeArchLib(platformNativeLibraryName);
    }

    private static String safeArchLib(String platformNativeLibraryName) {
        String arch = System.getProperty("os.arch");
        if (Arrays.asList(X86_VARIANTS).contains(arch)) {
            arch = "x86-64";
        }
        return String.format("lib/%s/%s", arch, platformNativeLibraryName);
    }
}

