/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.consensus;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.swirlds.base.test.fixtures.time.FakeTime;
import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.metrics.noop.NoOpMetrics;
import com.swirlds.component.framework.component.ComponentWiring;
import com.swirlds.component.framework.model.DeterministicWiringModel;
import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.component.framework.model.WiringModelBuilder;
import com.swirlds.component.framework.schedulers.TaskScheduler;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import com.swirlds.component.framework.wires.SolderType;
import com.swirlds.component.framework.wires.output.OutputWire;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.components.DefaultEventWindowManager;
import com.swirlds.platform.components.EventWindowManager;
import com.swirlds.platform.components.consensus.ConsensusEngine;
import com.swirlds.platform.components.consensus.ConsensusEngineOutput;
import com.swirlds.platform.components.consensus.DefaultConsensusEngine;
import com.swirlds.platform.consensus.ConsensusConfig;
import com.swirlds.platform.consensus.EventWindowUtils;
import com.swirlds.platform.consensus.SyntheticSnapshot;
import com.swirlds.platform.event.orphan.DefaultOrphanBuffer;
import com.swirlds.platform.event.orphan.OrphanBuffer;
import com.swirlds.platform.freeze.FreezeCheckHolder;
import com.swirlds.platform.gossip.IntakeEventCounter;
import com.swirlds.platform.gossip.NoOpIntakeEventCounter;
import com.swirlds.platform.test.fixtures.consensus.framework.ConsensusOutput;
import com.swirlds.platform.wiring.components.PassThroughWiring;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.hiero.consensus.crypto.DefaultEventHasher;
import org.hiero.consensus.crypto.EventHasher;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.ConsensusRound;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;

public class TestIntake {
    private final ConsensusOutput output;
    private final ComponentWiring<EventHasher, PlatformEvent> hasherWiring;
    private final ComponentWiring<OrphanBuffer, List<PlatformEvent>> orphanBufferWiring;
    private final ComponentWiring<ConsensusEngine, ConsensusEngineOutput> consensusEngineWiring;
    private final Queue<Throwable> componentExceptions = new LinkedList<Throwable>();
    private final DeterministicWiringModel model;
    private final int roundsNonAncient;
    private final FreezeCheckHolder freezeCheckHolder;
    private final FakeTime time = new FakeTime(Duration.of(1L, ChronoUnit.SECONDS));

    public TestIntake(@NonNull PlatformContext platformContext, @NonNull Roster roster) {
        NodeId selfId = NodeId.of((long)0L);
        this.roundsNonAncient = ((ConsensusConfig)platformContext.getConfiguration().getConfigData(ConsensusConfig.class)).roundsNonAncient();
        this.output = new ConsensusOutput();
        this.model = (DeterministicWiringModel)WiringModelBuilder.create((Metrics)new NoOpMetrics(), (Time)this.time).deterministic().build();
        this.hasherWiring = new ComponentWiring((WiringModel)this.model, EventHasher.class, this.scheduler("eventHasher"));
        DefaultEventHasher eventHasher = new DefaultEventHasher();
        this.hasherWiring.bind((Object)eventHasher);
        PassThroughWiring postHashCollectorWiring = new PassThroughWiring((WiringModel)this.model, "PlatformEvent", "postHashCollector", TaskSchedulerType.DIRECT);
        NoOpIntakeEventCounter intakeEventCounter = new NoOpIntakeEventCounter();
        DefaultOrphanBuffer orphanBuffer = new DefaultOrphanBuffer(platformContext.getMetrics(), (IntakeEventCounter)intakeEventCounter);
        this.orphanBufferWiring = new ComponentWiring((WiringModel)this.model, OrphanBuffer.class, this.scheduler("orphanBuffer"));
        this.orphanBufferWiring.bind((Object)orphanBuffer);
        this.freezeCheckHolder = new FreezeCheckHolder();
        this.freezeCheckHolder.setFreezeCheckRef(i -> false);
        DefaultConsensusEngine consensusEngine = new DefaultConsensusEngine(platformContext, roster, selfId, this.freezeCheckHolder);
        this.consensusEngineWiring = new ComponentWiring((WiringModel)this.model, ConsensusEngine.class, this.scheduler("consensusEngine"));
        this.consensusEngineWiring.bind((Object)consensusEngine);
        ComponentWiring eventWindowManagerWiring = new ComponentWiring((WiringModel)this.model, EventWindowManager.class, this.scheduler("eventWindowManager"));
        eventWindowManagerWiring.bind((Object)new DefaultEventWindowManager());
        this.hasherWiring.getOutputWire().solderTo(postHashCollectorWiring.getInputWire());
        postHashCollectorWiring.getOutputWire().solderTo(this.orphanBufferWiring.getInputWire(OrphanBuffer::handleEvent));
        OutputWire splitOutput = this.orphanBufferWiring.getSplitOutput();
        splitOutput.solderTo(this.consensusEngineWiring.getInputWire(ConsensusEngine::addEvent));
        OutputWire consensusRoundOutputWire = this.consensusEngineWiring.getOutputWire().buildTransformer("getConsRounds", "consensusEngineOutput", ConsensusEngineOutput::consensusRounds).buildSplitter("consensusRoundsSplitter", "consensusRounds");
        consensusRoundOutputWire.solderTo(eventWindowManagerWiring.getInputWire(EventWindowManager::extractEventWindow));
        this.consensusEngineWiring.getOutputWire().solderTo("consensusOutputTestTool", "consensus output", this.output::consensusEngineOutput);
        eventWindowManagerWiring.getOutputWire().solderTo(this.orphanBufferWiring.getInputWire(OrphanBuffer::setEventWindow), SolderType.INJECT);
        this.hasherWiring.getInputWire(EventHasher::hashEvent);
        this.consensusEngineWiring.getInputWire(ConsensusEngine::outOfBandSnapshotUpdate);
        this.model.start();
    }

    public void addEvent(@NonNull PlatformEvent event) {
        this.hasherWiring.getInputWire(EventHasher::hashEvent).put((Object)event);
        this.output.eventAdded(event);
        this.model.doAllWork();
        this.throwComponentExceptionsIfAny();
    }

    @NonNull
    public LinkedList<ConsensusRound> getConsensusRounds() {
        return this.output.getConsensusRounds();
    }

    public void loadSnapshot(@NonNull ConsensusSnapshot snapshot) {
        EventWindow eventWindow = EventWindowUtils.createEventWindow((ConsensusSnapshot)snapshot, (int)this.roundsNonAncient);
        this.orphanBufferWiring.getInputWire(OrphanBuffer::setEventWindow).put((Object)eventWindow);
        this.consensusEngineWiring.getInputWire(ConsensusEngine::outOfBandSnapshotUpdate).put((Object)snapshot);
        this.throwComponentExceptionsIfAny();
    }

    @NonNull
    public ConsensusOutput getOutput() {
        return this.output;
    }

    @NonNull
    public FreezeCheckHolder getFreezeCheckHolder() {
        return this.freezeCheckHolder;
    }

    public void reset() {
        this.time.reset();
        this.loadSnapshot(SyntheticSnapshot.getGenesisSnapshot());
        this.output.clear();
    }

    private void throwComponentExceptionsIfAny() {
        this.componentExceptions.stream().findFirst().ifPresent(t -> {
            throw new RuntimeException((Throwable)t);
        });
    }

    public <X> TaskScheduler<X> scheduler(String name) {
        return this.model.schedulerBuilder(name).withType(TaskSchedulerType.SEQUENTIAL).withUncaughtExceptionHandler((t, e) -> this.componentExceptions.add(e)).build();
    }
}

