/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.platform.event.preconsensus.CommonPcesWriter;
import com.swirlds.platform.event.preconsensus.PcesConfig;
import com.swirlds.platform.event.preconsensus.PcesFileManager;
import com.swirlds.platform.event.preconsensus.PcesFileReader;
import com.swirlds.platform.event.preconsensus.PcesFileTracker;
import com.swirlds.platform.event.preconsensus.PcesMultiFileIterator;
import com.swirlds.platform.state.snapshot.SavedStateMetadata;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.hiero.consensus.model.event.PlatformEvent;

public final class SavedStateUtils {
    private static final String PCES_TEMPORARY_DIR = "pces-tmp";

    private SavedStateUtils() {
    }

    public static int prepareStateForTransplant(@NonNull Path statePath, @NonNull PlatformContext platformContext) throws IOException {
        Path pcesFiles = statePath.resolve(((PcesConfig)platformContext.getConfiguration().getConfigData(PcesConfig.class)).databaseDirectory());
        Path pcesTmp = statePath.resolve(PCES_TEMPORARY_DIR);
        Files.move(pcesFiles, pcesTmp, StandardCopyOption.REPLACE_EXISTING);
        SavedStateMetadata stateMetadata = SavedStateMetadata.parse(statePath.resolve("stateMetadata.txt"));
        PcesFileTracker fileTracker = PcesFileReader.readFilesFromDisk(platformContext.getConfiguration(), platformContext.getRecycleBin(), pcesTmp, stateMetadata.round(), false);
        PcesMultiFileIterator eventIterator = fileTracker.getEventIterator(stateMetadata.minimumBirthRoundNonAncient(), stateMetadata.round());
        CommonPcesWriter pcesWriter = new CommonPcesWriter(platformContext, new PcesFileManager(platformContext, new PcesFileTracker(), pcesFiles, stateMetadata.round()));
        pcesWriter.beginStreamingNewEvents();
        int discardedEventCount = 0;
        while (eventIterator.hasNext()) {
            PlatformEvent event = eventIterator.next();
            if (event.getBirthRound() > stateMetadata.round()) {
                ++discardedEventCount;
                continue;
            }
            pcesWriter.prepareOutputStream(event);
            pcesWriter.getCurrentMutableFile().writeEvent(event);
        }
        pcesWriter.closeCurrentMutableFile();
        FileUtils.deleteDirectory((Path)pcesTmp);
        return discardedEventCount;
    }
}

