/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.cli.logging;

import com.swirlds.cli.logging.LogLine;
import com.swirlds.common.formatting.TextEffect;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class LogProcessingUtils {
    private LogProcessingUtils() {
    }

    @NonNull
    public static TextEffect getLogLevelColor(@NonNull String logLevel) {
        return switch (logLevel) {
            case "TRACE", "DEBUG", "INFO" -> LogLine.HARMLESS_LOG_LEVEL_COLOR;
            case "WARN" -> LogLine.WARN_LOG_LEVEL_COLOR;
            default -> LogLine.ERROR_LOG_LEVEL_COLOR;
        };
    }

    public static Instant parseTimestamp(@NonNull String timestampString, @NonNull ZoneId zoneId) {
        return LocalDateTime.parse(timestampString, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS")).atZone(zoneId).toInstant();
    }

    @NonNull
    static String colorizeLogLineAnsi(@NonNull String inputString, @NonNull ZoneId zoneId) {
        try {
            LogLine logLine = new LogLine(inputString, zoneId);
            return logLine.generateAnsiString();
        }
        catch (Exception e) {
            return inputString;
        }
    }

    @NonNull
    public static String escapeString(@NonNull String inputString) {
        return inputString.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("\u2019", "&#39;");
    }
}

