/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.handlers;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.contract.ContractCallTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.utils.fee.SigValueObj;
import com.hedera.node.app.hapi.utils.fee.SmartContractFeeBuilder;
import com.hedera.node.app.service.contract.impl.ContractServiceComponent;
import com.hedera.node.app.service.contract.impl.exec.CallOutcome;
import com.hedera.node.app.service.contract.impl.exec.TransactionComponent;
import com.hedera.node.app.service.contract.impl.handlers.AbstractContractTransactionHandler;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import com.hedera.node.app.service.contract.impl.utils.ConstantUtils;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.spi.validation.Validations;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hederahashgraph.api.proto.java.FeeData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;

@Singleton
public class ContractCallHandler
extends AbstractContractTransactionHandler {
    @Inject
    public ContractCallHandler(@NonNull Provider<TransactionComponent.Factory> provider, @NonNull GasCalculator gasCalculator, @NonNull EntityIdFactory entityIdFactory, @NonNull ContractServiceComponent component) {
        super(provider, gasCalculator, entityIdFactory, component);
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        TransactionComponent component = this.getTransactionComponent(context, HederaFunctionality.CONTRACT_CALL);
        CallOutcome outcome = component.contextTransactionProcessor().call();
        ContractCallStreamBuilder streamBuilder = (ContractCallStreamBuilder)context.savepointStack().getBaseBuilder(ContractCallStreamBuilder.class);
        outcome.addCallDetailsTo(streamBuilder, context, this.entityIdFactory);
        ConversionUtils.throwIfUnsuccessfulCall(outcome, component.hederaOperations(), streamBuilder);
    }

    public void preHandle(@NonNull PreHandleContext context) {
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        try {
            TransactionBody txn = context.body();
            ContractCallTransactionBody op = txn.contractCallOrThrow();
            Validations.mustExist((Object)op.contractID(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_CONTRACT_ID);
            if (op.contractID().hasEvmAddress()) {
                com.hedera.pbj.runtime.io.buffer.Bytes evmAddress = op.contractID().evmAddressOrThrow();
                PreCheckException.validateTruePreCheck((evmAddress.length() == 20L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_CONTRACT_ID);
                PreCheckException.validateFalsePreCheck((boolean)Arrays.equals(ConstantUtils.ZERO_ADDRESS_BYTE_ARRAY, evmAddress.toByteArray()), (ResponseCodeEnum)ResponseCodeEnum.INVALID_CONTRACT_ID);
            } else if (op.contractID().hasContractNum()) {
                ContractID contractId = op.contractID();
                PreCheckException.validateFalsePreCheck((boolean)ConstantUtils.ZERO_CONTRACT_ID.equals((Object)contractId), (ResponseCodeEnum)ResponseCodeEnum.INVALID_CONTRACT_ID);
            }
            long intrinsicGas = this.gasCalculator.transactionIntrinsicGasCost(Bytes.wrap((byte[])op.functionParameters().toByteArray()), false, 0L);
            PreCheckException.validateTruePreCheck((op.gas() >= intrinsicGas ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_GAS);
        }
        catch (Exception e) {
            this.bumpExceptionMetrics(HederaFunctionality.CONTRACT_CALL, e);
            throw e;
        }
    }

    @Override
    @NonNull
    protected FeeData getFeeMatrices(@NonNull SmartContractFeeBuilder usageEstimator, @NonNull com.hederahashgraph.api.proto.java.TransactionBody txBody, @NonNull SigValueObj sigValObj) {
        return usageEstimator.getContractCallTxFeeMatrices(txBody, sigValObj);
    }
}

