/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.model;

import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.component.framework.model.diagram.ModelEdgeSubstitution;
import com.swirlds.component.framework.model.diagram.ModelGroup;
import com.swirlds.component.framework.model.diagram.ModelManualLink;
import com.swirlds.component.framework.model.internal.analysis.CycleFinder;
import com.swirlds.component.framework.model.internal.analysis.DirectSchedulerChecks;
import com.swirlds.component.framework.model.internal.analysis.InputWireChecks;
import com.swirlds.component.framework.model.internal.analysis.InputWireDescriptor;
import com.swirlds.component.framework.model.internal.analysis.ModelEdge;
import com.swirlds.component.framework.model.internal.analysis.ModelVertex;
import com.swirlds.component.framework.model.internal.analysis.ModelVertexMetaType;
import com.swirlds.component.framework.model.internal.analysis.StandardVertex;
import com.swirlds.component.framework.model.internal.analysis.WiringFlowchart;
import com.swirlds.component.framework.schedulers.TaskScheduler;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import com.swirlds.component.framework.wires.SolderType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class TraceableWiringModel
implements WiringModel {
    private final Map<String, ModelVertex> vertices = new HashMap<String, ModelVertex>();
    private final Set<ModelEdge> edges = new HashSet<ModelEdge>();
    private final Set<InputWireDescriptor> inputWires = new HashSet<InputWireDescriptor>();
    private final Set<InputWireDescriptor> boundInputWires = new HashSet<InputWireDescriptor>();
    private final Set<InputWireDescriptor> solderedInputWires = new HashSet<InputWireDescriptor>();
    protected final List<TaskScheduler<?>> schedulers = new ArrayList();
    private boolean started = false;
    private final boolean backpressureEnabled;

    TraceableWiringModel(boolean backpressureEnabled) {
        this.backpressureEnabled = backpressureEnabled;
    }

    public boolean isBackpressureEnabled() {
        return this.backpressureEnabled;
    }

    @Override
    public boolean checkForCyclicalBackpressure() {
        return CycleFinder.checkForCyclicalBackPressure(this.vertices.values());
    }

    @Override
    public boolean checkForIllegalDirectSchedulerUsage() {
        return DirectSchedulerChecks.checkForIllegalDirectSchedulerUse(this.vertices.values());
    }

    @Override
    public boolean checkForUnboundInputWires() {
        return InputWireChecks.checkForUnboundInputWires(this.inputWires, this.boundInputWires);
    }

    @Override
    @NonNull
    public String generateWiringDiagram(@NonNull List<ModelGroup> groups, @NonNull List<ModelEdgeSubstitution> substitutions, @NonNull List<ModelManualLink> manualLinks, boolean moreMystery) {
        this.addVertexForUnsolderedInputWires(moreMystery);
        WiringFlowchart flowchart = new WiringFlowchart(this.vertices, substitutions, groups, manualLinks);
        return flowchart.render();
    }

    private void addVertexForUnsolderedInputWires(boolean moreMystery) {
        HashSet<InputWireDescriptor> unsolderedInputWires = new HashSet<InputWireDescriptor>(this.inputWires);
        unsolderedInputWires.removeAll(this.solderedInputWires);
        if (unsolderedInputWires.isEmpty()) {
            return;
        }
        StandardVertex unsolderedDataSource = new StandardVertex("Mystery Input", TaskSchedulerType.DIRECT_THREADSAFE, ModelVertexMetaType.SCHEDULER, null, true);
        this.vertices.put(unsolderedDataSource.getName(), unsolderedDataSource);
        for (InputWireDescriptor unsolderedInputWire : unsolderedInputWires) {
            ModelVertex destination = this.getVertex(unsolderedInputWire.taskSchedulerName());
            String edgeDescription = moreMystery ? "mystery data" : unsolderedInputWire.name();
            ModelEdge edge = new ModelEdge(unsolderedDataSource, destination, edgeDescription, true, true);
            unsolderedDataSource.getOutgoingEdges().add(edge);
        }
    }

    public void registerScheduler(@NonNull TaskScheduler<?> scheduler, @Nullable String hyperlink) {
        this.throwIfStarted();
        Objects.requireNonNull(scheduler);
        this.schedulers.add(scheduler);
        this.registerVertex(scheduler.getName(), scheduler.getType(), hyperlink, scheduler.isInsertionBlocking());
    }

    public void registerVertex(@NonNull String vertexName, @NonNull TaskSchedulerType type, @Nullable String hyperlink, boolean insertionIsBlocking) {
        boolean unique;
        this.throwIfStarted();
        Objects.requireNonNull(vertexName);
        Objects.requireNonNull(type);
        boolean bl = unique = this.vertices.put(vertexName, new StandardVertex(vertexName, type, ModelVertexMetaType.SCHEDULER, hyperlink, insertionIsBlocking)) == null;
        if (!unique) {
            throw new IllegalArgumentException("Duplicate vertex name: " + vertexName);
        }
    }

    public void registerEdge(@NonNull String originVertex, @NonNull String destinationVertex, @NonNull String label, @NonNull SolderType solderType) {
        this.throwIfStarted();
        boolean blockingEdge = solderType == SolderType.PUT;
        ModelVertex origin = this.getVertex(originVertex);
        ModelVertex destination = this.getVertex(destinationVertex);
        boolean blocking = blockingEdge && destination.isInsertionIsBlocking();
        ModelEdge edge = new ModelEdge(origin, destination, label, blocking, false);
        origin.getOutgoingEdges().add(edge);
        boolean unique = this.edges.add(edge);
        if (!unique) {
            throw new IllegalArgumentException("Duplicate edge: " + originVertex + " -> " + destinationVertex + ", label = " + label);
        }
        this.solderedInputWires.add(new InputWireDescriptor(destinationVertex, label));
    }

    public void registerInputWireCreation(@NonNull String taskSchedulerName, @NonNull String inputWireName) {
        this.throwIfStarted();
        boolean unique = this.inputWires.add(new InputWireDescriptor(taskSchedulerName, inputWireName));
        if (!unique) {
            throw new IllegalStateException("Duplicate input wire " + inputWireName + " for scheduler " + taskSchedulerName);
        }
    }

    public void registerInputWireBinding(@NonNull String taskSchedulerName, @NonNull String inputWireName) {
        this.throwIfStarted();
        InputWireDescriptor descriptor = new InputWireDescriptor(taskSchedulerName, inputWireName);
        boolean registered = this.inputWires.contains(descriptor);
        if (!registered) {
            throw new IllegalStateException("Input wire " + inputWireName + " for scheduler " + taskSchedulerName + " was not registered");
        }
        boolean unique = this.boundInputWires.add(descriptor);
        if (!unique) {
            throw new IllegalStateException("Input wire " + inputWireName + " for scheduler " + taskSchedulerName + " should not be bound more than once");
        }
    }

    protected void throwIfStarted() {
        if (this.started) {
            throw new IllegalStateException("start() has already been called, operation not permitted.");
        }
    }

    protected void throwIfNotStarted() {
        if (!this.started) {
            throw new IllegalStateException("start() has not been called, operation not permitted.");
        }
    }

    protected void markAsStarted() {
        this.started = true;
    }

    @NonNull
    private ModelVertex getVertex(@NonNull String vertexName) {
        ModelVertex vertex = this.vertices.get(vertexName);
        if (vertex != null) {
            return vertex;
        }
        StandardVertex adHocVertex = new StandardVertex(vertexName, TaskSchedulerType.DIRECT, ModelVertexMetaType.SCHEDULER, null, true);
        this.vertices.put(vertexName, adHocVertex);
        return adHocVertex;
    }
}

