/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.sync;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.metrics.noop.NoOpMetrics;
import com.swirlds.common.test.fixtures.platform.TestPlatformContextBuilder;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.common.threading.pool.CachedPoolParallelExecutor;
import com.swirlds.common.threading.pool.ParallelExecutor;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.extensions.test.fixtures.TestConfigBuilder;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.gossip.FallenBehindMonitor;
import com.swirlds.platform.gossip.IntakeEventCounter;
import com.swirlds.platform.gossip.NoOpIntakeEventCounter;
import com.swirlds.platform.gossip.shadowgraph.Shadowgraph;
import com.swirlds.platform.gossip.shadowgraph.ShadowgraphInsertionException;
import com.swirlds.platform.gossip.shadowgraph.ShadowgraphSynchronizer;
import com.swirlds.platform.internal.EventImpl;
import com.swirlds.platform.metrics.SyncMetrics;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.test.fixtures.event.emitter.EventEmitter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.hiero.consensus.crypto.DefaultEventHasher;
import org.hiero.consensus.crypto.EventHasher;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.test.fixtures.hashgraph.EventWindowBuilder;
import org.mockito.Mockito;

public class SyncNode {
    private final BlockingQueue<PlatformEvent> receivedEventQueue;
    private final List<EventImpl> generatedEvents;
    private final List<EventImpl> discardedEvents;
    private final List<PlatformEvent> receivedEvents;
    private final NodeId nodeId;
    private final int numNodes;
    private final EventEmitter eventEmitter;
    private int eventsEmitted = 0;
    private final FallenBehindMonitor fallenBehindMonitor;
    private final Shadowgraph shadowGraph;
    private ParallelExecutor executor;
    private Connection connection;
    private boolean saveGeneratedEvents;
    private boolean shouldAcceptSync = true;
    private boolean reconnected = false;
    private long expirationThreshold;
    private Exception syncException;
    private final AtomicInteger sleepAfterEventReadMillis = new AtomicInteger(0);
    private final AtomicReference<Boolean> synchronizerReturn = new AtomicReference<Object>(null);
    private final PlatformContext platformContext;

    public SyncNode(int numNodes, long nodeId, EventEmitter eventEmitter) {
        this(numNodes, nodeId, eventEmitter, (ParallelExecutor)new CachedPoolParallelExecutor(AdHocThreadManager.getStaticThreadManager(), "sync-node"));
    }

    public SyncNode(int numNodes, long nodeId, EventEmitter eventEmitter, ParallelExecutor executor) {
        if (executor.isMutable()) {
            executor.start();
        }
        this.numNodes = numNodes;
        this.nodeId = NodeId.of((long)nodeId);
        this.eventEmitter = eventEmitter;
        this.receivedEventQueue = new LinkedBlockingQueue<PlatformEvent>();
        this.receivedEvents = new ArrayList<PlatformEvent>();
        this.generatedEvents = new LinkedList<EventImpl>();
        this.discardedEvents = new LinkedList<EventImpl>();
        this.saveGeneratedEvents = false;
        Configuration configuration = new TestConfigBuilder().withValue("sync.filterLikelyDuplicates", false).withValue("sync.maxSyncEventCount", 0).getOrCreateConfig();
        this.fallenBehindMonitor = new TestFallenBehindMonitor(numNodes - 1, configuration, (Metrics)new NoOpMetrics());
        this.platformContext = TestPlatformContextBuilder.create().withConfiguration(configuration).build();
        this.shadowGraph = new Shadowgraph(this.platformContext, numNodes, (IntakeEventCounter)new NoOpIntakeEventCounter());
        this.shadowGraph.updateEventWindow(EventWindow.getGenesisEventWindow());
        this.executor = executor;
    }

    public void setSyncConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public List<EventImpl> generateAndAdd(int numEvents) {
        return this.generateAndAdd(numEvents, e -> true);
    }

    public List<EventImpl> generateAndAdd(int numEvents, Predicate<EventImpl> shouldAddToGraph) {
        if (this.eventEmitter == null) {
            throw new IllegalStateException("SyncNode.setEventGenerator(ShuffledEventGenerator) must be called prior to generateAndAdd(int)");
        }
        this.eventsEmitted += numEvents;
        this.eventEmitter.setCheckpoint(this.eventsEmitted);
        List<EventImpl> newEvents = this.eventEmitter.emitEvents(numEvents);
        for (EventImpl newEvent : newEvents) {
            if (shouldAddToGraph.test(newEvent)) {
                this.addToShadowGraph(newEvent.getBaseEvent());
                if (!this.saveGeneratedEvents) continue;
                this.generatedEvents.add(newEvent);
                continue;
            }
            this.discardedEvents.add(newEvent);
        }
        return List.copyOf(newEvents);
    }

    private void addToShadowGraph(PlatformEvent newEvent) {
        try {
            this.shadowGraph.addEvent(newEvent);
        }
        catch (ShadowgraphInsertionException e) {
            Assertions.fail((String)"Something went wrong adding initial events to the shadow graph.", (Throwable)e);
        }
    }

    public void drainReceivedEventQueue() {
        this.receivedEventQueue.drainTo(this.receivedEvents);
        DefaultEventHasher hasher = new DefaultEventHasher();
        this.receivedEvents.forEach(arg_0 -> ((EventHasher)hasher).hashEvent(arg_0));
    }

    public ShadowgraphSynchronizer getSynchronizer() {
        Consumer<PlatformEvent> eventHandler = event -> {
            if (this.sleepAfterEventReadMillis.get() > 0) {
                try {
                    Thread.sleep(this.sleepAfterEventReadMillis.get());
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.receivedEventQueue.add((PlatformEvent)event);
        };
        Configuration configuration = new TestConfigBuilder().withValue("sync.filterLikelyDuplicates", false).withValue("sync.maxSyncEventCount", 0).getOrCreateConfig();
        PlatformContext platformContext = TestPlatformContextBuilder.create().withConfiguration(configuration).build();
        return new ShadowgraphSynchronizer(platformContext, this.shadowGraph, this.numNodes, (SyncMetrics)Mockito.mock(SyncMetrics.class), eventHandler, this.fallenBehindMonitor, (IntakeEventCounter)Mockito.mock(IntakeEventCounter.class), this.executor, lag -> {});
    }

    public void expireBelow(long expirationThreshold) {
        this.expirationThreshold = expirationThreshold;
        long ancientThreshold = Math.max(this.shadowGraph.getEventWindow().ancientThreshold(), expirationThreshold);
        EventWindow eventWindow = EventWindowBuilder.builder().setAncientThreshold(ancientThreshold).setExpiredThreshold(expirationThreshold).build();
        this.updateEventWindow(eventWindow);
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public int getNumNodes() {
        return this.numNodes;
    }

    public EventEmitter getEmitter() {
        return this.eventEmitter;
    }

    public Shadowgraph getShadowGraph() {
        return this.shadowGraph;
    }

    public void updateEventWindow(@NonNull EventWindow eventWindow) {
        this.shadowGraph.updateEventWindow(eventWindow);
    }

    public FallenBehindMonitor getFallenBehindMonitor() {
        return this.fallenBehindMonitor;
    }

    public List<PlatformEvent> getReceivedEvents() {
        return this.receivedEvents;
    }

    public List<EventImpl> getGeneratedEvents() {
        return this.generatedEvents;
    }

    public void setSaveGeneratedEvents(boolean saveGeneratedEvents) {
        this.saveGeneratedEvents = saveGeneratedEvents;
    }

    public boolean isCanAcceptSync() {
        return this.shouldAcceptSync;
    }

    public void setCanAcceptSync(boolean canAcceptSync) {
        this.shouldAcceptSync = canAcceptSync;
    }

    public boolean isReconnected() {
        return this.reconnected;
    }

    public void setReconnected(boolean reconnected) {
        this.reconnected = reconnected;
    }

    public Exception getSyncException() {
        return this.syncException;
    }

    public void setSyncException(Exception syncException) {
        this.syncException = syncException;
    }

    public void setParallelExecutor(ParallelExecutor executor) {
        this.executor = executor;
    }

    public long getCurrentAncientThreshold() {
        return this.shadowGraph.getEventWindow().ancientThreshold();
    }

    public long getExpirationThreshold() {
        return this.expirationThreshold;
    }

    public int getSleepAfterEventReadMillis() {
        return this.sleepAfterEventReadMillis.get();
    }

    public void setSleepAfterEventReadMillis(int sleepAfterEventReadMillis) {
        this.sleepAfterEventReadMillis.set(sleepAfterEventReadMillis);
    }

    public void setSynchronizerReturn(Boolean value) {
        this.synchronizerReturn.set(value);
    }

    public Boolean getSynchronizerReturn() {
        return this.synchronizerReturn.get();
    }

    private static class TestFallenBehindMonitor
    extends FallenBehindMonitor {
        private boolean fallenBehind = false;

        public TestFallenBehindMonitor(int numNeighbors, @NonNull Configuration config, @NonNull Metrics metrics) {
            super(numNeighbors, config, metrics);
        }

        public synchronized void report(@NonNull NodeId id) {
            this.fallenBehind = true;
        }

        public synchronized void clear(@NonNull NodeId id) {
            this.fallenBehind = false;
        }

        public synchronized void checkAndNotifyFallingBehind() {
            super.checkAndNotifyFallingBehind();
        }

        public synchronized void update(@NonNull Set<NodeId> added, @NonNull Set<NodeId> removed) {
        }

        public boolean wasReportedByPeer(@NonNull NodeId peerId) {
            return false;
        }

        public synchronized void reset() {
            this.fallenBehind = false;
        }

        public synchronized int reportedSize() {
            return 0;
        }

        public boolean hasFallenBehind() {
            return this.fallenBehind;
        }
    }
}

