/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network.protocol;

import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.platform.gossip.FallenBehindMonitor;
import com.swirlds.platform.metrics.ReconnectMetrics;
import com.swirlds.platform.network.protocol.Protocol;
import com.swirlds.platform.network.protocol.ReservedSignedStatePromise;
import com.swirlds.platform.reconnect.StateSyncPeerProtocol;
import com.swirlds.platform.reconnect.StateSyncThrottle;
import com.swirlds.platform.state.SwirldStateManager;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatus;

public class StateSyncProtocol
implements Protocol {
    private final StateSyncThrottle stateSyncThrottle;
    private final Supplier<ReservedSignedState> lastCompleteSignedState;
    private final Duration reconnectSocketTimeout;
    private final ReconnectMetrics reconnectMetrics;
    private final ThreadManager threadManager;
    private final FallenBehindMonitor fallenBehindManager;
    private final PlatformStateFacade platformStateFacade;
    private final Time time;
    private final PlatformContext platformContext;
    private final AtomicReference<PlatformStatus> platformStatus = new AtomicReference<PlatformStatus>(PlatformStatus.STARTING_UP);
    private final ReservedSignedStatePromise reservedSignedStatePromise;
    private final SwirldStateManager swirldStateManager;
    private final Function<VirtualMap, MerkleNodeState> createStateFromVirtualMap;

    public StateSyncProtocol(@NonNull PlatformContext platformContext, @NonNull ThreadManager threadManager, @NonNull StateSyncThrottle stateSyncThrottle, @NonNull Supplier<ReservedSignedState> lastCompleteSignedState, @NonNull Duration reconnectSocketTimeout, @NonNull ReconnectMetrics reconnectMetrics, @NonNull FallenBehindMonitor fallenBehindManager, @NonNull PlatformStateFacade platformStateFacade, @NonNull ReservedSignedStatePromise reservedSignedStatePromise, @NonNull SwirldStateManager swirldStateManager, @NonNull Function<VirtualMap, MerkleNodeState> createStateFromVirtualMap) {
        this.platformContext = Objects.requireNonNull(platformContext);
        this.threadManager = Objects.requireNonNull(threadManager);
        this.stateSyncThrottle = Objects.requireNonNull(stateSyncThrottle);
        this.lastCompleteSignedState = Objects.requireNonNull(lastCompleteSignedState);
        this.reconnectSocketTimeout = Objects.requireNonNull(reconnectSocketTimeout);
        this.reconnectMetrics = Objects.requireNonNull(reconnectMetrics);
        this.fallenBehindManager = Objects.requireNonNull(fallenBehindManager);
        this.platformStateFacade = platformStateFacade;
        this.time = Objects.requireNonNull(platformContext.getTime());
        this.reservedSignedStatePromise = Objects.requireNonNull(reservedSignedStatePromise);
        this.swirldStateManager = Objects.requireNonNull(swirldStateManager);
        this.createStateFromVirtualMap = Objects.requireNonNull(createStateFromVirtualMap);
    }

    @Override
    @NonNull
    public StateSyncPeerProtocol createPeerInstance(@NonNull NodeId peerId) {
        return new StateSyncPeerProtocol(this.platformContext, this.threadManager, Objects.requireNonNull(peerId), this.stateSyncThrottle, this.lastCompleteSignedState, this.reconnectSocketTimeout, this.reconnectMetrics, this.fallenBehindManager, this.platformStatus::get, this.time, this.platformStateFacade, this.reservedSignedStatePromise, this.swirldStateManager, this.createStateFromVirtualMap);
    }

    @Override
    public void updatePlatformStatus(@NonNull PlatformStatus status) {
        this.platformStatus.set(status);
    }
}

