/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.util.HapiUtils;
import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.filesystem.FileSystemManager;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.io.utility.RecycleBin;
import com.swirlds.common.merkle.crypto.MerkleCryptography;
import com.swirlds.common.merkle.crypto.MerkleCryptographyFactory;
import com.swirlds.common.threading.framework.config.ThreadConfiguration;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.config.api.source.ConfigSource;
import com.swirlds.config.extensions.sources.SystemEnvironmentConfigSource;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.ApplicationDefinition;
import com.swirlds.platform.ApplicationDefinitionLoader;
import com.swirlds.platform.CommandLineArgs;
import com.swirlds.platform.ParameterProvider;
import com.swirlds.platform.SwirldsPlatform;
import com.swirlds.platform.builder.PlatformBuilder;
import com.swirlds.platform.builder.internal.StaticPlatformBuilder;
import com.swirlds.platform.config.BasicConfig;
import com.swirlds.platform.config.PathsConfig;
import com.swirlds.platform.crypto.CryptoStatic;
import com.swirlds.platform.gui.GuiEventStorage;
import com.swirlds.platform.gui.hashgraph.internal.StandardGuiSource;
import com.swirlds.platform.gui.internal.BrowserWindowManager;
import com.swirlds.platform.gui.internal.StateHierarchy;
import com.swirlds.platform.gui.internal.WinBrowser;
import com.swirlds.platform.gui.model.InfoApp;
import com.swirlds.platform.gui.model.InfoMember;
import com.swirlds.platform.gui.model.InfoSwirld;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.signed.HashedReservedSignedState;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.signed.StartupStateUtils;
import com.swirlds.platform.system.SwirldMain;
import com.swirlds.platform.system.SystemExitCode;
import com.swirlds.platform.system.SystemExitUtils;
import com.swirlds.platform.system.address.AddressBookUtils;
import com.swirlds.platform.util.BootstrapUtils;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.CryptographyProvider;
import org.hiero.base.io.SelfSerializable;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.roster.AddressBook;
import org.hiero.consensus.roster.RosterHistory;
import org.hiero.consensus.roster.RosterRetriever;
import org.hiero.consensus.roster.RosterUtils;

@Deprecated(forRemoval=true)
public class Browser {
    private static Logger logger = LogManager.getLogger(Browser.class);
    private static final AtomicBoolean STARTED = new AtomicBoolean(false);

    public static void main(String[] args) {
        Browser.parseCommandLineArgsAndLaunch(args);
    }

    public static void parseCommandLineArgsAndLaunch(String ... args) {
        CommandLineArgs commandLineArgs = CommandLineArgs.parse(args);
        Browser.launch(commandLineArgs, false);
    }

    public static void launch(@NonNull CommandLineArgs commandLineArgs, boolean pcesRecovery) {
        if (STARTED.getAndSet(true)) {
            return;
        }
        StaticPlatformBuilder.initLogging();
        logger = LogManager.getLogger(Browser.class);
        try {
            Browser.launchUnhandled(commandLineArgs, pcesRecovery);
        }
        catch (Throwable e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Unable to start Browser", e);
            throw new RuntimeException("Unable to start Browser", e);
        }
    }

    private static void launchUnhandled(@NonNull CommandLineArgs commandLineArgs, boolean pcesRecovery) throws Exception {
        StandardGuiSource guiSource;
        GuiEventStorage guiEventStorage;
        Objects.requireNonNull(commandLineArgs);
        ConfigurationBuilder bootstrapConfigBuilder = ConfigurationBuilder.create().withSource((ConfigSource)SystemEnvironmentConfigSource.getInstance());
        BootstrapUtils.setupConfigBuilder(bootstrapConfigBuilder, FileUtils.getAbsolutePath((String)"settings.txt"));
        Configuration bootstrapConfiguration = bootstrapConfigBuilder.build();
        PathsConfig defaultPathsConfig = (PathsConfig)bootstrapConfiguration.getConfigData(PathsConfig.class);
        ApplicationDefinition appDefinition = ApplicationDefinitionLoader.loadDefault(defaultPathsConfig, FileUtils.getAbsolutePath((String)"config.txt"));
        AddressBook appAddressBook = appDefinition.getConfigAddressBook();
        List<NodeId> configNodesToRun = ((BasicConfig)bootstrapConfiguration.getConfigData(BasicConfig.class)).nodesToRun();
        Set<NodeId> cliNodesToRun = commandLineArgs.localNodesToStart();
        Set validNodeIds = appAddressBook.getNodeIdSet();
        List<NodeId> nodesToRun = BootstrapUtils.getNodesToRun(cliNodesToRun, configNodesToRun, () -> validNodeIds, validNodeIds::contains);
        logger.info(LogMarker.STARTUP.getMarker(), "The following nodes {} are set to run locally", nodesToRun);
        Map<NodeId, SwirldMain> appMains = BootstrapUtils.loadSwirldMains(appDefinition, nodesToRun);
        ParameterProvider.getInstance().setParameters(appDefinition.getAppParameters());
        boolean showUi = !GraphicsEnvironment.isHeadless();
        Metrics guiMetrics = null;
        if (showUi) {
            Roster guiRoster = RosterRetriever.buildRoster((AddressBook)appDefinition.getConfigAddressBook());
            BootstrapUtils.setupBrowserWindow();
            BrowserWindowManager.setStateHierarchy(new StateHierarchy(null));
            InfoApp infoApp = BrowserWindowManager.getStateHierarchy().getInfoApp(appDefinition.getApplicationName());
            InfoSwirld infoSwirld = new InfoSwirld(infoApp, new byte[48]);
            new InfoMember(infoSwirld, "Node" + nodesToRun.getFirst().id());
            CryptoStatic.initNodeSecurity(appDefinition.getConfigAddressBook(), bootstrapConfiguration, Set.copyOf(nodesToRun));
            guiEventStorage = new GuiEventStorage(bootstrapConfiguration, guiRoster);
            guiSource = new StandardGuiSource(guiRoster, guiEventStorage);
        } else {
            guiSource = null;
            guiEventStorage = null;
        }
        HashMap<NodeId, SwirldsPlatform> platforms = new HashMap<NodeId, SwirldsPlatform>();
        for (int index = 0; index < nodesToRun.size(); ++index) {
            NodeId nodeId = nodesToRun.get(index);
            SwirldMain appMain = appMains.get(nodeId);
            ConfigurationBuilder configBuilder = ConfigurationBuilder.create();
            List<Class<Record>> configTypes = appMain.getConfigDataTypes();
            for (Class<Record> configType : configTypes) {
                configBuilder.withConfigDataType(configType);
            }
            FileUtils.rethrowIO(() -> BootstrapUtils.setupConfigBuilder(configBuilder, FileUtils.getAbsolutePath((String)"settings.txt"), FileUtils.getAbsolutePath((String)"data/config/node-overrides.yaml")));
            Configuration configuration = configBuilder.build();
            StaticPlatformBuilder.setupGlobalMetrics(configuration);
            guiMetrics = StaticPlatformBuilder.getMetricsProvider().createPlatformMetrics(nodeId);
            RecycleBin recycleBin = RecycleBin.create((Metrics)guiMetrics, (Configuration)configuration, (ThreadManager)AdHocThreadManager.getStaticThreadManager(), (Time)Time.getCurrent(), (FileSystemManager)FileSystemManager.create((Configuration)configuration), (NodeId)nodeId);
            Cryptography cryptography = CryptographyProvider.getInstance();
            KeysAndCerts keysAndCerts = CryptoStatic.initNodeSecurity(appDefinition.getConfigAddressBook(), configuration, Set.copyOf(nodesToRun)).get(nodeId);
            cryptography.digestSync((SelfSerializable)appDefinition.getConfigAddressBook());
            MerkleCryptography merkleCryptography = MerkleCryptographyFactory.create((Configuration)configuration);
            BootstrapUtils.setupConstructableRegistryWithConfiguration(configuration);
            PlatformContext platformContext = PlatformContext.create((Configuration)configuration, (Time)Time.getCurrent(), (Metrics)guiMetrics, (FileSystemManager)FileSystemManager.create((Configuration)configuration), (RecycleBin)recycleBin, (MerkleCryptography)merkleCryptography);
            PlatformStateFacade platformStateFacade = new PlatformStateFacade();
            ConsensusStateEventHandler consensusStateEventHandler = appMain.newConsensusStateEvenHandler();
            HashedReservedSignedState reservedState = StartupStateUtils.getInitialState(recycleBin, appMain.getSemanticVersion(), appMain::newStateRoot, appMain.stateRootFromVirtualMap(), appMain.getClass().getName(), appDefinition.getSwirldName(), nodeId, appDefinition.getConfigAddressBook(), platformStateFacade, platformContext);
            ReservedSignedState initialState = reservedState.state();
            AddressBookUtils.initializeAddressBook(nodeId, appMain.getSemanticVersion(), initialState, appDefinition.getConfigAddressBook(), platformContext, consensusStateEventHandler, platformStateFacade);
            MerkleNodeState state = initialState.get().getState();
            if (HapiUtils.SEMANTIC_VERSION_COMPARATOR.compare(appMain.getSemanticVersion(), platformStateFacade.creationSemanticVersionOf((State)state)) > 0) {
                long initialStateRound = platformStateFacade.roundOf((State)state);
                platformStateFacade.bulkUpdateOf((State)state, v -> v.setLatestFreezeRound(initialStateRound));
            }
            RosterHistory rosterHistory = RosterUtils.createRosterHistory((State)state);
            PlatformBuilder builder = PlatformBuilder.create(appMain.getClass().getName(), appDefinition.getSwirldName(), appMain.getSemanticVersion(), initialState, consensusStateEventHandler, nodeId, String.valueOf(nodeId), rosterHistory, platformStateFacade, appMain.stateRootFromVirtualMap());
            if (showUi && index == 0) {
                builder.withPreconsensusEventCallback(guiEventStorage::handlePreconsensusEvent);
                builder.withConsensusSnapshotOverrideCallback(guiEventStorage::handleSnapshotOverride);
            }
            builder.withExecutionLayer(appMain);
            SwirldsPlatform platform = (SwirldsPlatform)builder.withConfiguration(configuration).withPlatformContext(platformContext).withKeysAndCerts(keysAndCerts).build();
            platforms.put(nodeId, platform);
            if (!showUi || index != 0) continue;
            guiMetrics = platform.getContext().getMetrics();
        }
        BrowserWindowManager.addPlatforms(platforms.values());
        if (pcesRecovery) {
            platforms.values().forEach(SwirldsPlatform::performPcesRecovery);
            SystemExitUtils.exitSystem(SystemExitCode.NO_ERROR, "PCES recovery done");
        }
        Browser.startPlatforms(new ArrayList<SwirldsPlatform>(platforms.values()), appMains);
        if (showUi) {
            BrowserWindowManager.setBrowserWindow(new WinBrowser(nodesToRun.getFirst(), guiSource, guiEventStorage.getConsensus(), guiMetrics));
            BrowserWindowManager.showBrowserWindow(null);
            BrowserWindowManager.moveBrowserWindowToFront();
        }
    }

    private static void startPlatforms(@NonNull List<SwirldsPlatform> platforms, @NonNull Map<NodeId, SwirldMain> appMains) {
        ArrayList<Thread> startThreads = new ArrayList<Thread>();
        for (SwirldsPlatform platform : platforms) {
            Thread thread = ((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setThreadName("start-node-" + platform.getSelfId().id())).setRunnable(() -> Browser.startPlatform(platform, (SwirldMain)appMains.get(platform.getSelfId()))).build(true);
            startThreads.add(thread);
        }
        for (Thread startThread : startThreads) {
            try {
                startThread.join();
            }
            catch (InterruptedException e) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Interrupted while waiting for platform to start", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private static void startPlatform(@NonNull SwirldsPlatform platform, @NonNull SwirldMain appMain) {
        appMain.init(platform, platform.getSelfId());
        platform.start();
        ((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setNodeId(platform.getSelfId())).setComponent("app")).setThreadName("appMain")).setRunnable((Runnable)appMain).setDaemon(false)).build(true);
    }
}

