/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.reconnect;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.metrics.FunctionGauge;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.reconnect.FallenBehindStatus;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;

public class FallenBehindMonitor {
    private int peersSize;
    private final Set<NodeId> reportFallenBehind = new HashSet<NodeId>();
    private final double fallenBehindThreshold;
    private boolean isBehind;

    public FallenBehindMonitor(@NonNull Roster roster, @NonNull Configuration config, @NonNull Metrics metrics) {
        this(Objects.requireNonNull(roster).rosterEntries().size() - 1, ((ReconnectConfig)Objects.requireNonNull(config).getConfigData(ReconnectConfig.class)).fallenBehindThreshold());
        Objects.requireNonNull(metrics).getOrCreate((MetricConfig)new FunctionGauge.Config("internal", "hasFallenBehind", Object.class, this::hasFallenBehind).withDescription("has this node fallen behind?"));
        metrics.getOrCreate((MetricConfig)new FunctionGauge.Config("internal", "numReportFallenBehind", Integer.class, this::reportedSize).withDescription("the number of nodes that have fallen behind").withUnit("count"));
    }

    @VisibleForTesting
    public FallenBehindMonitor(int peersSize, double fallenBehindThreshold) {
        this.peersSize = peersSize;
        this.fallenBehindThreshold = fallenBehindThreshold;
    }

    private void checkAndNotify() {
        boolean wasNotBehind = !this.isBehind;
        boolean bl = this.isBehind = (double)this.peersSize * this.fallenBehindThreshold < (double)this.reportFallenBehind.size();
        if (wasNotBehind && this.isBehind) {
            this.notifyAll();
        }
    }

    synchronized void report(@NonNull NodeId id) {
        if (this.reportFallenBehind.add(id)) {
            this.checkAndNotify();
        }
    }

    synchronized void clear(@NonNull NodeId id) {
        this.reportFallenBehind.remove(id);
        this.checkAndNotify();
    }

    public synchronized void update(@NonNull Set<NodeId> added, @NonNull Set<NodeId> removed) {
        Objects.requireNonNull(added);
        Objects.requireNonNull(removed);
        this.peersSize += added.size() - removed.size();
        for (NodeId nodeId : removed) {
            if (!this.reportFallenBehind.contains(nodeId) || added.contains(nodeId)) continue;
            this.reportFallenBehind.remove(nodeId);
        }
        this.checkAndNotify();
    }

    public synchronized boolean hasFallenBehind() {
        return this.isBehind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasReportedByPeer(@NonNull NodeId peerId) {
        FallenBehindMonitor fallenBehindMonitor = this;
        synchronized (fallenBehindMonitor) {
            return this.reportFallenBehind.contains(peerId);
        }
    }

    public synchronized void reset() {
        this.reportFallenBehind.clear();
        this.isBehind = false;
    }

    public synchronized int reportedSize() {
        return this.reportFallenBehind.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitFallenBehind() throws InterruptedException {
        FallenBehindMonitor fallenBehindMonitor = this;
        synchronized (fallenBehindMonitor) {
            while (!this.isBehind) {
                this.wait();
            }
        }
    }

    public FallenBehindStatus check(@NonNull EventWindow self, @NonNull EventWindow other, @NonNull NodeId peer) {
        Objects.requireNonNull(self);
        Objects.requireNonNull(other);
        Objects.requireNonNull(peer);
        FallenBehindStatus status = FallenBehindStatus.getStatus(self, other);
        if (status == FallenBehindStatus.SELF_FALLEN_BEHIND) {
            this.report(peer);
        } else {
            this.clear(peer);
        }
        return status;
    }
}

