/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network.protocol;

import com.google.common.annotations.VisibleForTesting;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.platform.gossip.FallenBehindMonitor;
import com.swirlds.platform.gossip.IntakeEventCounter;
import com.swirlds.platform.gossip.permits.SyncPermitProvider;
import com.swirlds.platform.gossip.shadowgraph.ShadowgraphSynchronizer;
import com.swirlds.platform.gossip.sync.protocol.SyncPeerProtocol;
import com.swirlds.platform.metrics.SyncMetrics;
import com.swirlds.platform.network.protocol.AbstractSyncProtocol;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatus;

public class SyncProtocol
extends AbstractSyncProtocol<ShadowgraphSynchronizer> {
    private static final Logger logger = LogManager.getLogger(SyncProtocol.class);
    private final PlatformContext platformContext;
    private final FallenBehindMonitor fallenBehindManager;
    private final Duration sleepAfterSync;
    private final SyncMetrics syncMetrics;
    private final AtomicReference<PlatformStatus> platformStatus = new AtomicReference<PlatformStatus>(PlatformStatus.STARTING_UP);

    public SyncProtocol(@NonNull PlatformContext platformContext, @NonNull ShadowgraphSynchronizer synchronizer, @NonNull FallenBehindMonitor fallenBehindManager, @NonNull IntakeEventCounter intakeEventCounter, @NonNull Duration sleepAfterSync, @NonNull SyncMetrics syncMetrics, int rosterSize) {
        super(synchronizer, platformContext, rosterSize, intakeEventCounter);
        this.platformContext = Objects.requireNonNull(platformContext);
        this.fallenBehindManager = Objects.requireNonNull(fallenBehindManager);
        this.sleepAfterSync = Objects.requireNonNull(sleepAfterSync);
        this.syncMetrics = Objects.requireNonNull(syncMetrics);
    }

    public static SyncProtocol create(@NonNull PlatformContext platformContext, @NonNull ShadowgraphSynchronizer synchronizer, @NonNull FallenBehindMonitor fallenBehindManager, @NonNull IntakeEventCounter intakeEventCounter, int rosterSize, SyncMetrics syncMetrics) {
        return new SyncProtocol(platformContext, synchronizer, fallenBehindManager, intakeEventCounter, Duration.ZERO, syncMetrics, rosterSize);
    }

    @Override
    @NonNull
    public SyncPeerProtocol createPeerInstance(@NonNull NodeId peerId) {
        return new SyncPeerProtocol(this.platformContext, Objects.requireNonNull(peerId), (ShadowgraphSynchronizer)this.synchronizer, this.permitProvider, this.intakeEventCounter, this.gossipHalted::get, this.sleepAfterSync, this.syncMetrics, this.platformStatus::get);
    }

    @Override
    public void updatePlatformStatus(@NonNull PlatformStatus status) {
        this.platformStatus.set(status);
    }

    @VisibleForTesting
    SyncPermitProvider getPermitProvider() {
        return this.permitProvider;
    }
}

