/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gossip;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.metrics.FunctionGauge;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.reconnect.PlatformReconnecter;
import com.swirlds.platform.system.status.StatusActionSubmitter;
import com.swirlds.platform.system.status.actions.FallenBehindAction;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hiero.consensus.model.node.NodeId;

public class FallenBehindMonitor {
    private int numNeighbors;
    private final Set<NodeId> reportFallenBehind = new HashSet<NodeId>();
    private StatusActionSubmitter statusActionSubmitter;
    private final ReconnectConfig config;
    private boolean previouslyFallenBehind;
    private PlatformReconnecter platformReconnecter;

    public FallenBehindMonitor(@NonNull Roster roster, @NonNull Configuration config, @NonNull Metrics metrics) {
        this(roster.rosterEntries().size() - 1, config, metrics);
    }

    @VisibleForTesting
    protected FallenBehindMonitor(int numNeighbors, @NonNull Configuration config, @NonNull Metrics metrics) {
        this.numNeighbors = numNeighbors;
        this.config = (ReconnectConfig)Objects.requireNonNull(config, "config must not be null").getConfigData(ReconnectConfig.class);
        metrics.getOrCreate((MetricConfig)new FunctionGauge.Config("internal", "hasFallenBehind", Object.class, this::hasFallenBehind).withDescription("has this node fallen behind?"));
        metrics.getOrCreate((MetricConfig)new FunctionGauge.Config("internal", "numReportFallenBehind", Integer.class, this::reportedSize).withDescription("the number of nodes that have fallen behind").withUnit("count"));
    }

    public synchronized void report(@NonNull NodeId id) {
        if (this.reportFallenBehind.add(id)) {
            this.checkAndNotifyFallingBehind();
            this.previouslyFallenBehind = true;
            this.platformReconnecter.start(this::reset, () -> {});
        }
    }

    public synchronized void clear(@NonNull NodeId id) {
        this.reportFallenBehind.remove(id);
    }

    public synchronized void checkAndNotifyFallingBehind() {
        if (!this.previouslyFallenBehind && this.hasFallenBehind()) {
            this.statusActionSubmitter.submitStatusAction(new FallenBehindAction());
            this.previouslyFallenBehind = true;
        }
    }

    public synchronized void update(@NonNull Set<NodeId> added, @NonNull Set<NodeId> removed) {
        Objects.requireNonNull(added);
        Objects.requireNonNull(removed);
        this.numNeighbors += added.size() - removed.size();
        for (NodeId nodeId : removed) {
            if (!this.reportFallenBehind.contains(nodeId) || added.contains(nodeId)) continue;
            this.reportFallenBehind.remove(nodeId);
        }
        this.checkAndNotifyFallingBehind();
    }

    public synchronized boolean hasFallenBehind() {
        return (double)this.numNeighbors * this.config.fallenBehindThreshold() < (double)this.reportFallenBehind.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasReportedByPeer(@NonNull NodeId peerId) {
        if (!this.hasFallenBehind()) {
            return false;
        }
        FallenBehindMonitor fallenBehindMonitor = this;
        synchronized (fallenBehindMonitor) {
            return this.reportFallenBehind.contains(peerId);
        }
    }

    public synchronized void reset() {
        this.reportFallenBehind.clear();
        this.previouslyFallenBehind = false;
    }

    public synchronized int reportedSize() {
        return this.reportFallenBehind.size();
    }

    public void bind(@NonNull StatusActionSubmitter statusActionSubmitter) {
        this.statusActionSubmitter = Objects.requireNonNull(statusActionSubmitter);
    }

    public void bind(@NonNull PlatformReconnecter reconnectStarter) {
        this.platformReconnecter = Objects.requireNonNull(reconnectStarter);
    }
}

