/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.consensus;

import com.swirlds.platform.internal.EventImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hiero.base.crypto.Hash;

public final class InitJudges {
    private final long round;
    private final Set<Hash> judgeHashes;
    private final List<EventImpl> judges;

    public InitJudges(long round, @NonNull Set<Hash> judgeHashes) {
        this.round = round;
        this.judgeHashes = judgeHashes;
        this.judges = new ArrayList<EventImpl>();
    }

    public long getRound() {
        return this.round;
    }

    public boolean isInitJudge(@NonNull Hash hash) {
        return this.judgeHashes.contains(hash);
    }

    public void judgeFound(@NonNull EventImpl judge) {
        this.judges.add(judge);
        this.judgeHashes.remove(judge.getBaseHash());
        judge.setRoundCreated(this.getRound());
        judge.setWitness(true);
        judge.setFamous(true);
        judge.setFameDecided(true);
        judge.setJudgeTrue();
    }

    public boolean initJudgesMissing() {
        return !this.judgeHashes.isEmpty();
    }

    public int numMissingJudges() {
        return this.judgeHashes.size();
    }

    @NonNull
    public List<EventImpl> getJudges() {
        return this.judges;
    }
}

