/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.lifecycle;

import com.swirlds.state.lifecycle.StateDefinition;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hiero.base.utility.CommonUtils;
import org.hiero.base.utility.NonCryptographicHashing;

public final class StateMetadata<K, V> {
    private final String serviceName;
    private final StateDefinition<K, V> stateDefinition;

    public StateMetadata(@NonNull String serviceName, @NonNull StateDefinition<K, V> stateDefinition) {
        Objects.requireNonNull(stateDefinition, "stateDefinition must not be null");
        this.serviceName = StateMetadata.validateServiceName(serviceName);
        this.stateDefinition = stateDefinition;
    }

    public static long hashString(@NonNull String s) {
        byte[] data = CommonUtils.getNormalisedStringBytes((String)s);
        return StateMetadata.hashBytes(data);
    }

    private static long hashBytes(@NonNull byte[] bytes) {
        int numBlocks = bytes.length / 8;
        long hash = 0L;
        for (int i = 0; i < numBlocks * 8; i += 8) {
            hash ^= (long)bytes[i] << 56;
            hash ^= (long)bytes[i + 1] << 48;
            hash ^= (long)bytes[i + 2] << 40;
            hash ^= (long)bytes[i + 3] << 32;
            hash ^= (long)(bytes[i + 4] << 24);
            hash ^= (long)(bytes[i + 5] << 16);
            hash ^= (long)(bytes[i + 6] << 8);
            hash ^= (long)bytes[i + 7];
            hash = NonCryptographicHashing.hash64((long)hash);
        }
        int numRemainingBytes = bytes.length - numBlocks * 8;
        if (numRemainingBytes > 0) {
            int shift = numRemainingBytes * 8;
            int i = numBlocks * 8;
            while (i < bytes.length) {
                hash ^= (long)bytes[i] << shift;
                ++i;
                shift -= 8;
            }
            hash = NonCryptographicHashing.hash64((long)hash);
        }
        return hash;
    }

    @NonNull
    public static String validateServiceName(@NonNull String serviceName) {
        if (Objects.requireNonNull(serviceName).isEmpty()) {
            throw new IllegalArgumentException("The service name must have characters");
        }
        return StateMetadata.validateIdentifier(serviceName);
    }

    @NonNull
    public static String validateStateKey(@NonNull String stateKey) {
        if (Objects.requireNonNull(stateKey).isEmpty()) {
            throw new IllegalArgumentException("The state key must have characters");
        }
        return StateMetadata.validateIdentifier(stateKey);
    }

    @NonNull
    public static String validateIdentifier(@NonNull String stateKey) {
        if (Objects.requireNonNull(stateKey).isEmpty()) {
            throw new IllegalArgumentException("The identifier must have characters");
        }
        for (int i = 0; i < stateKey.length(); ++i) {
            char c = stateKey.charAt(i);
            if (StateMetadata.isAsciiUnderscoreOrDash(c) || StateMetadata.isAsciiLetter(c) || StateMetadata.isAsciiNumber(c)) continue;
            throw new IllegalArgumentException("Illegal character '" + c + "' at position " + i);
        }
        return stateKey;
    }

    public static String computeLabel(@NonNull String serviceName, @NonNull String stateKey) {
        return Objects.requireNonNull(serviceName) + "." + Objects.requireNonNull(stateKey);
    }

    public static String computeLabel(@NonNull String serviceName, int stateId) {
        return Objects.requireNonNull(serviceName) + "." + stateId;
    }

    private static boolean isAsciiUnderscoreOrDash(char ch) {
        return ch == '-' || ch == '_';
    }

    private static boolean isAsciiLetter(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    private static boolean isAsciiNumber(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public String serviceName() {
        return this.serviceName;
    }

    @NonNull
    public StateDefinition<K, V> stateDefinition() {
        return this.stateDefinition;
    }
}

